<?php
// Inject CORE
$nestedLocation = '../';
include($nestedLocation . 'resources/includes/core/acpm/about/core.php');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->

      <!-- Breadcrumb-->
      <div class="container mt-5 mb-md-4 pt-4">
        <nav class="mb-3 pt-md-3" aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">About</li>
          </ol>
        </nav>
      </div>

      <!-- Page header-->
      <section class="container mb-5 pb-5" id="header">
        <div class="row align-items-center justify-content-center">
          <!-- Hero content-->
          <div class="col-lg-5 col-md-5 col-sm-9 order-md-1 order-2 text-md-start text-center">
            <h1 class="mb-4">About All County</h1>
            <p class="mb-4 pb-3 fs-lg">All County Property Management has offices across the country, but it didn’t begin that way. Sandy Ferrera started her career in buying and selling real estate. Being an investor herself, she quickly realized there was a need for someone who was knowledgeable and trustworthy to help owners and investors manage their properties. In 1990 she opened the first All County specializing in property management and over 30 years later All County continues to be a trusted leader in the property management industry.</p>
            <a class="btn btn-lg btn-primary" href="<?php echo $nestedLocation; ?>locations/">Find a Property Manager</a>
          </div>
          <!-- Hero carousel-->
          <div class="col-lg-6 col-md-6 offset-md-1 col-12 order-md-2 order-1 p-4">
            <div class="gallery" data-video="true" style="max-width: auto;">
            <a class="gallery-item video-item rounded-2" href="https://www.youtube.com/watch?v=Jouluya2gGI&feature=emb_title" data-sub-html="<h6 class=&quot;fs-sm text-light&quot;>Learn more about All County</h6>">
              <img src="https://i.ytimg.com/vi_webp/Jouluya2gGI/sddefault.webp" alt="Gallery thumbnail">
              <span class="gallery-item-caption">Learn more about All County</span>
            </a>
            </div>
          </div>
        </div>
      </section>

      <!-- PM's-->
      <?php include_once($nestedLocation . 'resources/layouts/widgets/pms.layout.php'); ?>

      <!-- CTA-->
      <?php include_once($nestedLocation . 'resources/layouts/widgets/cta.layout.php'); ?>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/lightgallery.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/fullscreen/lg-fullscreen.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/zoom/lg-zoom.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/video/lg-video.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/thumbnail/lg-thumbnail.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

    <div class="lg-container" id="lg-container-2" tabindex="-1" aria-modal="true" role="dialog">
      <div id="lg-backdrop-2" class="lg-backdrop" style="transition-duration: 300ms;"></div>
      <div id="lg-outer-2" class="lg-outer lg-use-css3 lg-css3 lg-single-item lg-slide lg-use-transition-for-zoom lg-hide-items lg-grab" data-lg-slide-type="video">
        <div id="lg-content-2" class="lg-content" style="top: 47px; bottom: 56px;">
          <div id="lg-inner-2" class="lg-inner" style="transition-timing-function: ease; transition-duration: 400ms;"></div>
          <button type="button" id="lg-prev-2" aria-label="Previous slide" class="lg-prev lg-icon">  </button>
          <button type="button" id="lg-next-2" aria-label="Next slide" class="lg-next lg-icon">  </button>
        </div>
        <div id="lg-toolbar-2" class="lg-toolbar lg-group"> 
          <button type="button" aria-label="Close gallery" id="lg-close-2" class="lg-close lg-icon"></button>
          <div class="lg-counter" role="status" aria-live="polite">
          <span id="lg-counter-current-2" class="lg-counter-current">1</span> /
          <span id="lg-counter-all-2" class="lg-counter-all">1 </span>
        </div>
        <button id="lg-actual-size-2" type="button" aria-label="View actual size" class="lg-zoom-in lg-icon"></button>
        <button type="button" aria-label="Toggle Fullscreen" class="lg-fullscreen lg-icon"></button>
      </div>
      <div id="lg-components-2" class="lg-components">
        <div class="lg-sub-html" role="status" aria-live="polite">
          <h6 class="fs-sm text-light">Gallery video caption</h6>
        </div>
      </div>
    </div>


  </body>
</html>