<?php

// Inject CORE // errrr... cant do it for state pages since we rely on directory paths to generate a state name
$nestedLocation = '../../';

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// Create state info based on working directory
$dirr = dirname(__FILE__);
$eachDirr = explode('/', $dirr);
$stateName = ucwords(str_replace('-', ' ', end($eachDirr)));
$stateAbr = array_search($stateName, $states);

// API Instance
$RMAPI = new API(2);

// Grab all of our offices
$locations = $RMAPI->getFranchisees();

// Filter offices to current state only
$filteredLocations = [];
foreach($locations as $location) {
  if($location['State'] == $stateAbr) {
    array_push($filteredLocations, $location);
  }
}

// Get location images
$officeData = new FetchOfficeData();
foreach($filteredLocations as $k => $individualOffice) {
  $latestOfficeImage = $officeData->getLatestImageData($individualOffice['Name'], 1);
  $officeImage =  $latestOfficeImage['url'];
  $filteredLocations[$k]['ImageURL'] = $officeImage;
}

// Set page parameters/meta
$pageType = 0;
$pageName = 'Locations';
$pageTitle = $stateName . ' Property Management | Rent Your Home in ' . $stateAbr;
$pageMetaDescription = 'All County is a full-service property management company with professionals ready to help you rent your home in ' . $stateName . '. Find a location nearest you.';
$pageMetaKeyword = array(
  'property management office', 'find a property management company', $stateName . ' property management', $stateAbr . ' property management'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>

    <!-- // Additional stylesheet for store locator -->
    <link rel="stylesheet" type="text/css" href="../assets/css/storelocator.css" />
    
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5">
        <div class="row g-0 mt-n3">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-5">

            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>locations/">Locations</a></li>
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>locations/states/">States</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $stateName; ?></li>
              </ol>
            </nav>

            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0"><?php echo $stateName; ?></h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted"><?php echo $pageMetaDescription; ?></p>
              </div>
            </div>

            
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <!-- Map + Offices -->
            <section class="container-fluid mt-3 p-0">

              <div class="row g-4 py-4">

                <?php foreach($filteredLocations as $location) { ?>
                <div class="col-sm-6 col-xl-4">
                  <div class="card shadow-sm card-hover border-0 h-100">
                    <a href="<?php echo $location['web site url']; ?>">
                      <div class="card-img-top card-img-hover state-office-image" style="background-image: url('<?php echo $location['ImageURL']; ?>');">
                      </div>
                    </a>
                    <div class="card-body position-relative pb-3">
                      <!-- <h4 class="mb-1 fs-xs fw-normal text-uppercase text-primary">For rent</h4> -->
                      <h3 class="h6 mb-2 fs-base"><a class="nav-link stretched-link" href="<?php echo $location['web site url']; ?>"><?php echo str_replace(' Property Management', '', $location['Franchise Name']); ?></a></h3>
                      <p class="mb-2 fs-sm text-muted"><?php echo $location['Street']; ?></p>
                      <?php if(!empty($location['City']) || !empty($location['State']) || !empty($location['PostalCode'])) { ?>
                      <p class="mb-2 fs-sm text-muted"><?php echo $location['City'] . ', ' . $location['State'] . ' ' . substr($location['PostalCode'], 0, 5); ?></p>
                      <?php } ?>
                      <p class="mb-2 fs-sm text-muted">Phone: <?php echo $location['Phone Number']; ?></p>
                    </div>
                    <div class="card-footer">
                      <div class="row">
                        <div class="col-12">
                          <a href="<?php echo $location['web site url']; ?>quote/" class="text-decoration-none"><button type="button" class="btn btn-translucent-info d-block w-100">Get a Quote</button></a>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <?php } ?>


              </div>

            </section>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

 
  </body>
</html>