<?php

// Inject CORE
$nestedLocation = '../../../';

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// Additional params
$region = 'Miami';
$state = 'Florida';
$stateAbr = 'FL';

// API Instance
$RMAPI = new API(2);

// Get locations
$locations = $RMAPI->getFranchisees();

// Set page parameters/meta
$pageType = 0;
$pageName = 'ACPM.Region';
$pageTitle = $region . ' Property Management | Rent Your Home';
$pageMetaDescription = 'Rent your ' . $region . ' property the easy way with All County. We take care of all accomodations of your invesement property.';
$pageMetaKeyword = array(
  'property management office', 'find a property management company', $region . ' property management', 'best ' . $region . ' property manager', 'rent my home', 'rent my home in ' . $region
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);


// Filter offices to current state only
$filteredLocations = [];
foreach($locations as $location) {
  if($location['Region Group'] == $region) {
    array_push($filteredLocations, $location);
  }
}

// Get location images
$officeData = new FetchOfficeData();
foreach($filteredLocations as $k => $individualOffice) {
  $latestOfficeImage = $officeData->getLatestImageData($individualOffice['Name'], 1);
  $officeImage =  $latestOfficeImage['url'];
  $filteredLocations[$k]['ImageURL'] = $officeImage;
}

?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- INC/LAYOUT - Head -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
  </head>
  <body>
    
    <!-- INC/LAYOUT - Page Loader & GTM-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- INC/LAYOUT - Navigation Bar -->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->

      <section class="pt-5 jarallax bg-light zindex-1 py-xxl-5" id="header"><span class="img-overlay bg-transparent opacity-100" style="background: linear-gradient(180deg, rgba(255,255,255,1) 0%, rgba(255,255,255,1) 18%, rgba(255,255,255,0.9023984593837535) 35%, rgba(255,255,255,0.6051155462184874) 100%); box-shadow: inset 0px -11px 8px -10px #CCC;"></span>
        <div class="jarallax-img" style="background-image: url(<?php echo $nestedLocation; ?>resources/img/regions/miami-region-bg.jpg); background-position: bottom center;"></div>
        <div class="content-overlay container py-5 px-sm-4">
          <div class="row pt-4">
            <div class="col-xl-5 col-lg-6 col-md-7 mb-3 text-md-start text-center">
              <h1 class="display-4 mt-lg-3 mb-md-4 mb-3 pt-md-4 pb-lg-2" style="word-spacing: 100vw;">
                <a class="text-primary fw-italic text-decoration-none"><?php echo $region; ?></a>
              <br>Property Management</h1>
              <p class="position-relative lead me-lg-n5 text-primary">Let's rent your home today!</p>
              <p class="position-relative lead me-lg-n5">Discover how our expert team can maximize your property's potential in <?php echo $region; ?> and provide you with peace of mind.</p>
              <br>
              <form class="form-group position-relative me-lg-n5 shadow-lg border-secondary" id="submit_zip" action="index.php" method="get">
                  <div class="input-group input-group-lg border-end-md"><span class="input-group-text text-muted rounded-pill ps-3"><i class="fi-map-pin mx-2"></i></span>
                    <input class="form-control" required id="address" name="address" type="text" placeholder="Enter your zip code" pattern="^\s*?\d{5}(?:[-\s]\d{4})?\s*?$">
                  </div>
                  <button class="btn btn-primary btn-lg w-md-auto ms-sm-3" type="submit" ><i class="fi-arrow-right mt-0 mx-2"></i></button>

                </form>
            </div>
          </div>
        </div>
      </section>


      <!-- Offices -->
      <section class="container pt-5 mb-5 pb-lg-5" id="statesWeService">
        <div class="d-flex align-items-center justify-content-center text-center">
          <h3 class="h3 mb-3 text-primary">Our Property Management Services in <?php echo $region; ?></h3>
          <!-- <a class="btn btn-link fw-normal p-0" href="locations/">View all offices<i class="fi-arrow-long-right ms-2"></i></a> -->
        </div>
        <div class="col-lg-12 mt-3">
          <!-- <h4 class="h4 mb-0">We're a full-service property management company.</h4> -->
          <!-- <br> -->
          <div class="text-center mb-4">
            <div class="row gy-4 align-items-lg-center">
              <div class="col-lg-6 col-md-6 order-md-1 order-2 pe-4 text-md-start text-center">
                <p>Welcome to All County Property Management, where we offer expert property management services designed to meet the needs of property owners and tenants in the Miami, FL area. With our deep-rooted knowledge of Miami's diverse real estate market, we provide exceptional service tailored to the unique characteristics of this vibrant city and its surrounding communities.</p>
                <br>
                <h4 class="h4 mb-0">Why <?php echo $region; ?>?</h4>
                <br>
                <p>Miami, known for its dynamic culture, thriving economy, and beautiful coastal surroundings, is one of Florida’s most desirable cities. From the bustling downtown area and trendy Wynwood district to the iconic neighborhoods of Coral Gables, Coconut Grove, and Miami Beach, the city offers a wide range of living environments and investment opportunities. Miami's strong job market, particularly in finance, tourism, healthcare, and technology, along with its world-renowned arts and entertainment scene, makes it an attractive location for both renters and property investors. With its international appeal, stunning waterfront, and year-round sunny weather, Miami continues to be a prime destination for those looking to live and invest in Florida.</p>
              </div>
              <div class="col-md-6 order-md-2 order-1 ps-4">
                <img class="rounded-3" src="<?php echo $nestedLocation; ?>resources/img/regions/miami-region-bg.jpg" alt="Regional image">
              </div>
            </div>
          </div>

          <br>
          <hr>

          <!-- Offices -->
          <div class="d-flex align-items-center justify-content-between mb-3 pt-5">
            <h2 class="h3 mb-3">We've Got Roots in <?php echo $region; ?></h2>
            <!-- <a class="btn btn-link fw-normal p-0" href="locations/">View all offices<i class="fi-arrow-long-right ms-2"></i></a> -->
          </div>
          <div class="tns-carousel-wrapper tns-nav-outside tns-nav-outside-flush mx-n2 rounded-3">
            <div class="tns-carousel-inner row gx-4 mx-0 py-3" data-carousel-options="{&quot;items&quot;: 4, &quot;controls&quot;: true, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:1},&quot;768&quot;:{&quot;items&quot;:4}}}">
              <?php foreach($filteredLocations as $location) { ?>
              <div class="col-sm-6 col-xl-4">
                <div class="card shadow-sm card-hover border-0 h-100">
                  <div class="card-img-top card-img-hover state-office-image" style="height: 250px; background-image: url('<?php echo $location['ImageURL']; ?>');">
                  </div>
                  <div class="card-body position-relative pt-4 pb-2 text-center">
                    <h6><?php echo str_replace(' Property Management', '', $location['Franchise Name']); ?></h6>
                  </div>
                </div>
              </div>
              <?php } ?>
            </div>
          </div>

          <br>
          <hr>

          <h4 class="h3 mb-0 mt-5">Professional services we offer:</h3>

          <div class="row pt-5">
              
            <div class="col-lg-12 d-flex align-items-stretch mb-5">
              <div class="card w-100 bg-gradient text-white text-center pt-3">
                <div class="card-header h5 border-0">
                  <i class="fi-rent mb-4 display-6"></i>
                  <br>
                  Local Expertise
                </div>
                <div class="card-body">
                  <p>
                  With extensive local expertise in Miami, we specialize in managing properties across the city's vibrant neighborhoods, including downtown, Brickell, and Miami Beach. Our deep understanding of the area's real estate trends and community dynamics allows us to provide personalized, effective property management services that maximize returns for property owners.</p>
                </div>
                <!-- <div class="card-footer border-0">
                  <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                </div> -->
              </div>
            </div>

            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Tenant Screening
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Comprehensive background checks, credit evaluations, and reference verifications to ensure you attract and retain reliable and responsible tenants.</p>
                </div>
              </div>
            </div>

            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Property Marketing
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Strategic marketing plans, including professional photography and listings on major rental platforms, to highlight your property’s best features and attract quality tenants quickly.</p>
                </div>
              </div>
            </div>

            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Maintenance and Repairs
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Efficient handling of maintenance and repair issues through a network of trusted local contractors, ensuring your property is well-maintained and any problems are addressed promptly.</p>
                </div>
                <!-- <div class="card-footer border-0">
                  <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                </div> -->
              </div>
            </div>

            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Rent Collection
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Streamlined rent collection processes with multiple payment options, including online payments, to ensure consistent and timely rental income.</p>
                </div>
                <!-- <div class="card-footer border-0">
                  <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                </div> -->
              </div>
            </div>

            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5 d-none">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Financial Reporting
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Transparent financial reporting with detailed statements of income, expenses, and property performance to keep you informed and facilitate informed decision-making.</p>
                </div>
                <!-- <div class="card-footer border-0">
                  <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                </div> -->
              </div>
            </div>

            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5 d-none">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Legal Compliance
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Expertise in Atlanta’s local, state, and federal regulations to ensure your property adheres to all legal requirements and to help prevent potential legal issues.</p>
                </div>
                <!-- <div class="card-footer border-0">
                  <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                </div> -->
              </div>
            </div>
            
            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Tenant Relations
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Responsive and professional tenant support to handle inquiries, resolve issues, and maintain high levels of tenant satisfaction.</p>
                </div>
                <!-- <div class="card-footer border-0">
                  <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                </div> -->
              </div>
            </div>
            
            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Property Inspections
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Regular property inspections to monitor the condition of your property, identify maintenance needs, and ensure it remains in top condition.</p>
                </div>
                <!-- <div class="card-footer border-0">
                  <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                </div> -->
              </div>
            </div>

            <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5 d-none">
              <div class="card w-100">
                <div class="card-header h5 bg-gradient text-white">
                  Eviction Services
                </div>
                <div class="card-body pb-0">
                  <div class="text-center my-3">
                    <i class="fi-user-check mb-4 display-6"></i>
                  </div>
                  <p>Assistance with the eviction process, including legal guidance and coordination with local authorities, to handle difficult situations with professionalism.</p>
                </div>
                <!-- <div class="card-footer border-0">
                  <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                </div> -->
              </div>
            </div>

          </div>
          <!-- <br>
          <p>Experience the benefits of working with a property management team that truly understands Atlanta. Contact us today to learn how we can help you manage your property with expertise and dedication.</p>
          <a class="btn btn-lg btn-primary" href="about/">Work with us!</a> -->
        </div>
      </section>

      <!-- Partner with us -->
      <hr>
      <section class="container mt-5 pb-5">
        <div class="row gy-4">
          <div class="col-md-5 col-12"><img class="d-block mx-auto" src="<?php echo $nestedLocation; ?>resources/img/acprop/home/sell.svg" alt="Illustration"></div>
          <div class="col-lg-6 offset-lg-1 col-md-7 col-12">
            <h2 class="h3 mb-lg-5 mb-sm-4">Why partner with a <?php echo $region; ?> market expert?</h2>
            <div class="steps steps-vertical">
              <div class="step active">
                <div class="step-progress"><span class="step-number"></span></div>
                <div class="step-label ms-4">
                  <h3 class="h5 mb-2 pb-1">Expertise in the Miami Market</h3>
                  <p class="mb-0">Partnering with us gives property owners access to our deep knowledge of the Miami real estate market. From the vibrant neighborhoods of downtown Miami and Brickell to the luxury condos of Miami Beach and the family-friendly areas like Coral Gables and Coconut Grove, we understand the unique dynamics of each community. Our expertise in local market trends, rental rates, and zoning regulations allows us to provide strategic advice and management services tailored to help maximize your property's profitability.</p>
                </div>
              </div>
              <div class="step active">
                <div class="step-progress"><span class="step-number"></span></div>
                <div class="step-label ms-4">
                  <h3 class="h5 mb-2 pb-1">Comprehensive Property Management Services</h3>
                  <p class="mb-0">Our full-service property management solutions cover everything you need to efficiently manage your investment in Miami. We handle tenant screening and placement, ensuring that only qualified tenants are chosen for your property. We also provide regular maintenance, emergency repairs, and 24/7 customer support, so you can rest assured your property is well-cared for. Our proactive marketing strategies ensure your property gets the visibility it needs to attract tenants quickly, while our detailed financial reporting keeps you informed of your investment’s performance.</p>
                </div>
              </div>
              <div class="step active">
                <div class="step-progress"><span class="step-number"></span></div>
                <div class="step-label ms-4">
                  <h3 class="h5 mb-2 pb-1">Focus on Tenant Retention & Satisfaction</h3>
                  <p class="mb-0">At All County Property Management, we prioritize tenant satisfaction to ensure long-term success for property owners. We offer responsive communication, quick resolution of any issues, and a commitment to maintaining properties in top condition. By fostering positive relationships with tenants, we reduce turnover and keep vacancy rates low, providing you with consistent rental income. Whether you own a high-rise apartment in downtown Miami or a single-family home in suburban Miami-Dade, we work hard to maintain a stable, profitable rental portfolio for you.</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- Reviews -->
      <hr>
      <section class="container mt-5 pb-5">
        <h2 class="mb-1">Reviews:</h2>
        <h6 class="mb-4 text-primary">Don't just take our word, see what actual owners have to say about All County.</h6>

        <div class="tns-carousel-wrapper tns-controls-outside-xxl tns-nav-outside tns-nav-outside-flush mx-n2">
          <div class="tns-carousel-inner row gx-4 mx-0 pt-3 pb-4" data-carousel-options="{&quot;items&quot;: 3, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:2},&quot;768&quot;:{&quot;items&quot;:3},&quot;992&quot;:{&quot;items&quot;:3}}}">

            <!-- Item-->
            <div class="col">
              <div class="card border-0 shadow-sm">
                <blockquote class="blockquote card-body">
                  <p class="font-italic">"I couldn't be happier with the property management services provided! The team is incredibly responsive and genuinely cares about my property as if it were their own. They handle everything from tenant screening to maintenance issues with professionalism and efficiency. It's such a relief knowing my investment is in such capable hands!"</p>
                  <footer class="d-flex justify-content-between">
                    <div class="pe-3">
                      <h6 class="mb-0">Christine Carter</h6>
                    </div>
                  </footer>
                </blockquote>
              </div>
            </div>

              <!-- Item-->
              <div class="col">
              <div class="card border-0 shadow-sm">
                <blockquote class="blockquote card-body">
                  <p class="font-italic">"As a property owner, finding reliable management can be challenging, but this team has exceeded my expectations. Their communication is top-notch, keeping me updated on everything happening with my property. I appreciate their proactive approach to maintenance and tenant relations, which has led to happy tenants and fewer vacancies. Highly recommend!"</p>
                  <footer class="d-flex justify-content-between">
                    <div class="pe-3">
                      <h6 class="mb-0">Micah Davis</h6>
                    </div>
                  </footer>
                </blockquote>
              </div>
            </div>

            <!-- Item-->
            <div class="col">
              <div class="card border-0 shadow-sm">
                <blockquote class="blockquote card-body">
                  <p class="font-italic">"I’ve worked with several property management companies over the years, but none compare to this one. They bring expertise and dedication to every aspect of managing my rental. Their thorough screening process has brought in excellent tenants, and I love the regular updates I receive. I feel confident and supported as an owner, which is invaluable!"</p>
                  <footer class="d-flex justify-content-between">
                    <div class="pe-3">
                      <h6 class="mb-0">Christopher Mathews</h6>
                    </div>
                  </footer>
                </blockquote>
              </div>
            </div>

          </div>
      </section>


      <!-- FAQ -->
      <hr>
      <section class="container mt-5 pb-5">
        <h2 class="mb-1">FAQ:</h2>
        <h6 class="mb-4 text-primary">Have question? We have answers!</h6>

        <div class="accordion" id="accordionFAQ">

              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-2">
                  <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-2" aria-expanded="true" aria-controls="collapse-2">How do you determine rental rates for my property?</button>
                </h2>
                <div class="accordion-collapse collapse show" aria-labelledby="heading-2" data-bs-parent="#accordionFAQ" id="collapse-2" style="">
                  <div class="accordion-body">We conduct a comprehensive market analysis, evaluating comparable properties in your area, current market trends, and the unique features of your property to establish a competitive and profitable rental rate.</div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-1">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-1" aria-expanded="false" aria-controls="collapse-1">What services do property management companies provide?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-1" data-bs-parent="#accordionFAQ" id="collapse-1" style="">
                  <div class="accordion-body">Property management companies handle tenant screening, leasing, rent collection, maintenance coordination, property inspections, and financial reporting. They manage all aspects of your rental property to ensure a smooth operation.</div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-3">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-3" aria-expanded="false" aria-controls="collapse-3">What is the tenant screening process like?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-3" data-bs-parent="#accordionFAQ" id="collapse-3">
                  <div class="accordion-body">Our tenant screening process includes background checks, credit history evaluations, employment verification, and rental history assessments. We ensure that only qualified tenants are placed in your property.</div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-4">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-4" aria-expanded="false" aria-controls="collapse-4">How do you handle maintenance requests from tenants?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-4" data-bs-parent="#accordionFAQ" id="collapse-4">
                  <div class="accordion-body">Tenants can submit maintenance requests through our online portal, which we address promptly. We have a network of licensed contractors for various repairs, ensuring timely and quality service.</div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-5">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-5" aria-expanded="false" aria-controls="collapse-5">What are the fees associated with your property management services?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-5" data-bs-parent="#accordionFAQ" id="collapse-5">
                  <div class="accordion-body">Fees typically include a monthly management fee, a leasing fee for new tenants, and maintenance fees. We provide a transparent breakdown of all costs in our management agreement.</div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-6">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-6" aria-expanded="false" aria-controls="collapse-6">How often will I receive updates on my property?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-6" data-bs-parent="#accordionFAQ" id="collapse-6">
                  <div class="accordion-body">We provide regular updates through monthly financial statements, maintenance reports, and tenant communications. You can also access real-time information via our online portal.</div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-7">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-7" aria-expanded="false" aria-controls="collapse-7">What happens if a tenant fails to pay rent?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-7" data-bs-parent="#accordionFAQ" id="collapse-7">
                  <div class="accordion-body">If a tenant misses a rent payment, we initiate our established collection procedures, which may include reminders, payment plans, and, if necessary, eviction processes in compliance with local laws.</div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-8">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-8" aria-expanded="false" aria-controls="collapse-8">How do you ensure compliance with local laws and regulations?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-8" data-bs-parent="#accordionFAQ" id="collapse-8">
                  <div class="accordion-body">Our team stays updated on local laws and regulations affecting rental properties in Atlanta. We ensure all leasing agreements, evictions, and maintenance procedures comply with current legal standards.</div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-9">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-9" aria-expanded="false" aria-controls="collapse-9">Can I still be involved in decision-making regarding my property?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-9" data-bs-parent="#accordionFAQ" id="collapse-9">
                  <div class="accordion-body">Absolutely! We encourage owner involvement and provide opportunities for you to make decisions regarding major repairs, renovations, or tenant selection while managing the day-to-day operations.</div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header py-2" id="heading-10">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-10" aria-expanded="false" aria-controls="collapse-10">What are the benefits of hiring a property management company?</button>
                </h2>
                <div class="accordion-collapse collapse" aria-labelledby="heading-10" data-bs-parent="#accordionFAQ" id="collapse-10">
                  <div class="accordion-body">Hiring a property management company saves you time and stress, provides professional expertise, enhances tenant satisfaction, and ultimately maximizes your rental income while ensuring your property is well maintained.</div>
                </div>
              </div>



            </div>
      </section>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <div class="modal fade" id="locator" tabindex="-1">
      <div class="modal-dialog modal modal-dialog-centered p-2 my-0 mx-auto">
        <div class="modal-content">
          <div class="modal-body px-0 py-2 py-sm-0">
            <button class="btn-close position-absolute top-0 end-0 mt-3 me-3" type="button" data-bs-dismiss="modal"></button>
            <div class="card-body w-100">
              <div class="card w-100 card-body border-0">
                <div class="w-100" id="#guestCard1" > 
                  <div class="guestCardFieldsUAContainer w-100">
                    <h3>Let's connect you with a professional property manager!</h3>
                    <!-- The form fields will be generated here -->
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

    <!-- Script for fullscreen map -->
    <script type="text/javascript" src="//maps.googleapis.com/maps/api/js?key=AIzaSyCQ5N81u7-cdQ665QokzjzJ3ZQe1HdmabE&libraries=places"></script>
    <script type="text/javascript" id="storelocatorscript" data-uid="D7kc8VYWof3ULCm1VmkUcQbuYFMOpj45" data-zoom="6" data-filters="Atlanta" data-address="Atlanta" data-settings="store_list_layout=Disabled" src="//cdn.storelocatorwidgets.com/widget/widget.js"></script>

    <script>
      $(document).ready(function () {
        $('#submit_zip').on('submit', function(e) {
            console.log('Data submitted');
            e.preventDefault();
            var zip = $('#address').val;
            console.log(zip);
            $('#locator').modal('show'); 
        });
      });
    </script>

  </body>
</html>