<?php
// Inject CORE
$nestedLocation = '../';
include($nestedLocation . 'resources/includes/core/acpm/locations/core.php');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>

    <!-- // Additional stylesheet for store locator -->
    <link rel="stylesheet" type="text/css" href="assets/css/storelocator.css" />
    
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5">
        <div class="row g-0 mt-n3">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-5">

            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Locations</li>
              </ol>
            </nav>

            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Locations</h1>
              <a class="d-inline-block mb-5 mb-md-0 fw-bold text-decoration-none py-1 text-center" href="<?php echo $nestedLocation; ?>locations/states/">View By State<br><span class="display-1 text-primary stateface stateface-replace stateface-us"></span></a>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted"><?php echo $pageMetaDescription; ?></p>
              </div>
            </div>
            
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <!-- Hero-->
            <section class="container-fluid bg-light mt-3 p-0">

              <div id="storelocatorwidget" style="width:100%;"><p>Loading <a href="https://www.storelocatorwidgets.com">Store Locator Software</a>...</p></div>
              
            </section>

            <!-- CTA-->
          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>
    <!-- Script for fullscreen map -->
    <script type="text/javascript" id="storelocatorscript" data-uid="D7kc8VYWof3ULCm1VmkUcQbuYFMOpj45" src="//cdn.storelocatorwidgets.com/widget/widget.js"></script>
    <script type="text/javascript" id="googlemapsscript" src="//maps.googleapis.com/maps/api/js?key=AIzaSyCQ5N81u7-cdQ665QokzjzJ3ZQe1HdmabE&libraries=places&callback=storeLocatorGoogleMapsCallback"></script>

    <?php if(isset($_GET['address'])) { ?>
      <script>
        document.addEventListener('DOMContentLoaded', function() {
          setTimeout(() => {
                      storeLocatorSetUserAddress("<?php echo $_GET['address']; ?>");
          }, 1000);
        }, false);
      </script>
    <?php } ?>
 
  </body>
</html>