<?php
// Inject CORE
$nestedLocation = '../../';
include($nestedLocation . 'resources/includes/core/acpm/locations/state/core.php');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>

    <!-- // Additional stylesheet for store locator -->
    <link rel="stylesheet" type="text/css" href="../assets/css/storelocator.css" />
    
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5">
        <div class="row g-0 mt-n3">
          <!-- Page content-->
          <div class="col-lg-12 pt-5">

            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>locations/">Locations</a></li>
                <li class="breadcrumb-item active" aria-current="page">States</li>
              </ol>
            </nav>

            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">States</h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted"><?php echo $pageMetaDescription; ?></p>
              </div>
            </div>

            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <!-- Option cards-->
            <section class="container mb-5 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="card-columns-4">
                <?php foreach($validStates as $state) { ?>
                  <div class="card mb-3 rounded p-0" style="border: 0px solid #e5e5e5;">
                    <div class="card-body p-0">
                      <h4 class="mt-2 mb-3 fw-bold"><?php echo $state['Name']; ?></h4>
                      <?php foreach($locations as $office) { if($office['State'] == $state['Abbreviation'] && $office['Franchise Name'] != 'Demo' ) { if(!empty($office['URL'])) { $webUrl = $nestedLocation . 'locations/' . $office['URL']; } else { $webUrl = $office['web site url']; } ?>
                        <a class="text-decoration-none" href="<?php echo $webUrl; ?>"><p class="my-lg-2 mx-0"><?php echo $office['Primary City']; ?></p></a>
                      <?php } } ?>
                      <a class="text-decoration-none" href="<?php echo $nestedLocation . 'locations/' . strtolower( str_replace(' ', '-', $state['Name'])) . '/'; ?>"><p class="fw-bold text-black text-decoration-none">View State</p></a>
                    </div>
                  </div>
                <?php } ?>
              </div>
            </section>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="../assets/js/libs/handlebars.min.js"></script>
    <script src="../assets/js/libs/markerclusterer.min.js"></script>
    <script src="https://maps.google.com/maps/api/js?key=AIzaSyB_Gi3u4O-b1fcwa0jnhW0RL2HV9MAC2Sg&libraries=places"></script>
    <script src="../assets/js/plugins/storeLocator/jquery.storelocator.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>
    <!-- Script for fullscreen map -->
    <script>
      $(function() {
          $('#bh-sl-map-container').storeLocator({
              <?php if(isset($_GET['autoLocate'])) { echo 'autoGeocode: true,'; }; ?>
              autoComplete: true,
              dataType: 'json',
              dataLocation: '../locations.php',
              infowindowTemplatePath: '../assets/js/plugins/storeLocator/templates/infowindow-description.html',
              listTemplatePath: '../assets/js/plugins/storeLocator/templates/location-list-description.html',
              // markerCluster: {
              //     imagePath: 'assets/img/m'
              // },
              disableAlphaMarkers: 1,
              fullMapStart: 1,
              storeLimit: -1,
              slideMap: false,
              defaultLoc: true,
              defaultLat: 31.54012,
              defaultLng: -82.68521,
              taxonomyFilters : {
                'state' : 'state-filter',
              }
            });
      });
  </script>
 
  </body>
</html>