<?php
// Inject CORE
$nestedLocation = '../';

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// Set page parameters/meta
$pageType = 0;
$pageName = 'Rentals';
$pageTitle = 'Homes for rent in ' . $locationData['Primary City'] . ', ' . $locationData['State'] . ' - ' . str_replace(" Property Management", "", $locationData['Franchise Name']);
$pageMetaDescription = 'Find homes for rent in ' . $locationData['Primary City'] . ', ' . $locationData['State'] . ' managed by the real estate professionals at All County Property Management.';
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'rentals', 'available rentals', 'apartments for rent', 'homes for rent'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Sanitize and validate user inputs (filters, page, etc.)
function sanitize_input($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// Validate page number
$page = 1; // Default
if (isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0) {
    $page = (int) $_GET['page'];
}

// Sort parameter validation
$valid_sort_options = ['price_asc', 'price_desc', 'date_soonest', 'date_latest'];
$sort = 'price_desc'; // Default
if (isset($_GET['sort']) && in_array($_GET['sort'], $valid_sort_options)) {
    $sort = sanitize_input($_GET['sort']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
</head>

<body>

    <style>
        /* Smooth scrolling transition */
        html {
            scroll-behavior: smooth;
        }

        /* Slide-in effect (delayed after scroll) */
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .listing-card {
            opacity: 0; /* Start hidden */
        }

        .listing-card.slide-in {
            animation: slideIn 0.5s ease-in-out forwards;
        }

        /* Fade-out effect */
        @keyframes slideOut {
            from {
                opacity: 1;
                transform: translateY(0);
            }
            to {
                opacity: 0;
                transform: translateY(-20px);
            }
        }

        .listing-card.fade-out {
            animation: slideOut 0.3s ease-in-out forwards;
        }

        .listing-card {
            margin-bottom: 20px;
        }
        .filter-container {
            margin-bottom: 20px;
        }
        /* ---- General Slider Styling ---- */
        #rent-slider {
            margin: 10px 0;
            height: 8px; /* Slimmer track */
            border-radius: 5px;
            background: #e0e0e0; /* Light gray background */
            box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1);
        }

        /* ---- Styling for the Filled Range (Selected Rent Range) ---- */
        #rent-slider .noUi-connect {
            background: linear-gradient(90deg, #007bff, #0056b3); /* Bootstrap Primary Blue */
            height: 100%;
            border-radius: 5px;
        }

        /* ---- Slider Handles ---- */
        #rent-slider .noUi-handle {
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: white;
            border: 2px solid #007bff;
            cursor: pointer;
            transition: transform 0.2s, background 0.2s;
        }

        /* Hover effect for handles */
        #rent-slider .noUi-handle:hover {
            background: #007bff;
            border: 2px solid white;
            transform: scale(1.2);
        }

        /* Active handle effect (when dragging) */
        #rent-slider .noUi-handle:active {
            background: #0056b3;
        }

        /* ---- Manual Input Fields ---- */
        .rent-inputs {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            margin-top: 5px;
        }

        .rent-inputs input {
            width: 80px;
            text-align: center;
            font-size: 14px;
            border: 2px solid #007bff;
            border-radius: 5px;
            padding: 5px;
            transition: all 0.2s ease-in-out;
        }

        .rent-inputs input:focus {
            border-color: #0056b3;
            box-shadow: 0 0 5px rgba(0, 91, 187, 0.5);
        }

        /* Floating Labels on Handles */
        .noUi-handle .slider-label {
            position: absolute;
            top: -30px;
            left: 50%;
            transform: translateX(-50%);
            background: #007bff;
            color: white;
            font-size: 12px;
            padding: 4px 6px;
            border-radius: 4px;
            white-space: nowrap;
            font-weight: bold;
            transition: opacity 0.2s;
            opacity: 0;
        }

        /* Show labels when moving */
        .noUi-handle:hover .slider-label,
        .noUi-handle:active .slider-label {
            opacity: 1;
        }


        /* ---- Responsive Adjustments ---- */
        @media (max-width: 768px) {
            .rent-inputs input {
                width: 60px;
                font-size: 12px;
            }
        }

        /* Hide the increment/decrement arrows in number input fields */
        .rent-inputs input[type="number"] {
            -moz-appearance: textfield; /* Firefox */
        }

        .rent-inputs input[type="number"]::-webkit-outer-spin-button,
        .rent-inputs input[type="number"]::-webkit-inner-spin-button {
            -webkit-appearance: none; /* Chrome, Safari, Edge */
            margin: 0;
        }
    </style>

<!-- Page loading spinner-->
<?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

<main class="page-wrapper">

    <!-- Navbar-->
    <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

    <div class="container pt-5">

        <div class="row g-0 mt-n3">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-5">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Rentals</li>
              </ol>
            </nav>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Available Rentals</h1>
              <a class="d-inline-block fw-bold text-decoration-none py-1" href="#guidelines" data-bs-toggle="modal"><i class="fi-checkbox-checked-alt me-2"></i>Rental Steps & Guidelines</a>
            </div>
            <div class="row mb-3">
              <div class="col-lg-5 col-md-6 col-sm-9 col-xs-10">
                <p class="mb-0 fs-lg text-muted">Our rentals range from studios to luxury properties. We have something for everyone. Take a look at some of the properties available.</p>
              </div>
              <div class="col-lg-7 col-md-6 col-sm-3 col-xs-2 justify-content-end text-end">
                <img class="swap-from me-3" src="<?php echo $nestedLocation; ?>resources/img/acprop/fair_housing.png" alt="Logo" width="70px">
              </div>
            </div>
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <div class="d-flex align-items-center flex-shrink-0">
                <label class="fs-sm me-2 pe-1 text-nowrap" for="sortby"><i class="fi-arrows-sort text-muted mt-n1 me-2"></i>Sort by:</label>


                            <select id="sort-options" class="form-select form-select-sm">
                                <option value="price_desc" <?php echo ($sort === 'price_desc') ? 'selected' : ''; ?>>Price: High to Low</option>
                                <option value="price_asc" <?php echo ($sort === 'price_asc') ? 'selected' : ''; ?>>Price: Low to High</option>
                                <option value="date_soonest" <?php echo ($sort === 'date_soonest') ? 'selected' : ''; ?>>Date Available: Soonest</option>
                                <option value="date_latest" <?php echo ($sort === 'date_latest') ? 'selected' : ''; ?>>Date Available: Latest</option>
                            </select>


              </div>
              <hr class="d-none d-sm-block w-100">
              <div class="d-none d-sm-flex align-items-center flex-shrink-0 text-muted"><i class="fi-check-circle me-2"></i><span class="totalCount fs-sm mt-n1">0 Results</span></div>
            </div>

            

        </div>

        <!-- Filters Panel -->
        <div class="row filter-container">
            <div class="col-md-2">
                <h5>Filters</h5>
                <form id="filters-form" method="POST">

                    <div class="mb-2" id="city-filters"></div>

                    <h6>Property Type</h6>
                    <div id="propertyType-filters"></div>


                    <h6>Beds</h6>
                    <div id="beds-filters"></div>

                    <h6>Baths</h6>
                    <div id="baths-filters"></div>

                    <h6>Pets</h6>
                    <div id="pets-filters">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="dogs" name="dogs">
                            <label for="dogs" class="form-check-label">Dogs Allowed</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="cats" name="cats">
                            <label for="cats" class="form-check-label">Cats Allowed</label>
                        </div>
                    </div>

                    <h6>Rent Amount</h6>
                    <div id="rent-slider"></div>
                    <div class="rent-inputs mt-2">
                        <input type="number" id="minRentInput" min="0" step="100" class="form-control form-control-sm">
                        <span> to </span>
                        <input type="number" id="maxRentInput" min="0" step="100" class="form-control form-control-sm">
                    </div>
                    <div class="d-none">
                        <p class="text-muted">Selected Rent: <span id="rent-range"></span></p>
                    </div>



                    <!-- <div class="range-slider" id="rent-slider"></div>
                    <p>Selected Rent: <span id="rent-range"></span></p> -->

                    

                    <button type="button" id="apply-filters" class="btn btn-primary mt-3">Apply Filters</button>
                </form>
            </div>
            <div class="col-md-10">
                <!-- Listings -->
                <div id="listings" class="row">
                    <!-- Listings will be dynamically populated here -->
                </div>
                <!-- Pagination -->
                <div id="pagination" class="py-4 text-center"></div>
            </div>
            <div class="col-md-3 d-none">
                <!-- Google Map Section -->
                <h5>Map</h5>
                <div id="map" style="height: 500px; width: 100%;"></div>
            </div>
        </div>
    </div>
    

</main>
<!-- <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCQ5N81u7-cdQ665QokzjzJ3ZQe1HdmabE&callback=initMap" type="text/javascript"></script> -->

<script>
const listingsContainer = document.getElementById('listings');
const paginationContainer = document.getElementById('pagination');
const propertyTypeFilters = document.getElementById('propertyType-filters');
const cityFilters = document.getElementById('city-filters');
const bedsFilters = document.getElementById('beds-filters');
const bathsFilters = document.getElementById('baths-filters');
let currentPage = <?php echo $page; ?>;
let totalPages = 0;

function fetchFilterOptions() {
    fetch('<?php echo $nestedLocation; ?>resources/helpers/listings-handler.php?action=getFilters', {
        method: 'GET',
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        console.log("Received filter data:", data); // Debugging

        if (isNaN(data.minRent) || isNaN(data.maxRent)) {
            console.error("Invalid min/max rent values received.");
            return;
        }

        populateFilters(data);

        // Initialize Rent Slider with Manual Inputs
        const rentSlider = document.getElementById('rent-slider');
        const minRentInput = document.getElementById('minRentInput');
        const maxRentInput = document.getElementById('maxRentInput');
        const rentRangeText = document.getElementById('rent-range');

        noUiSlider.create(rentSlider, {
            start: [parseInt(data.minRent), parseInt(data.maxRent)],
            connect: true,
            range: {
                'min': parseInt(data.minRent),
                'max': parseInt(data.maxRent)
            },
            step: 50,
            format: {
                to: function(value) {
                    return Math.round(value);
                },
                from: function(value) {
                    return Number(value);
                }
            }
        });

// Add floating labels for slider handles
rentSlider.noUiSlider.on('update', function(values, handle) {
    minRentInput.value = values[0];
    maxRentInput.value = values[1];
    rentRangeText.textContent = `$${values[0]} - $${values[1]}`;

    // Create floating labels
    const handles = rentSlider.getElementsByClassName('noUi-handle');
    handles[handle].innerHTML = `<div class="slider-label">$${values[handle]}</div>`;
});

        // Update slider when inputs change
        function updateSliderFromInput() {
            let minVal = parseInt(minRentInput.value, 10);
            let maxVal = parseInt(maxRentInput.value, 10);

            if (isNaN(minVal)) minVal = data.minRent;
            if (isNaN(maxVal)) maxVal = data.maxRent;
            if (minVal < data.minRent) minVal = data.minRent;
            if (maxVal > data.maxRent) maxVal = data.maxRent;
            if (minVal > maxVal) minVal = maxVal; // Prevent overlap

            rentSlider.noUiSlider.set([minVal, maxVal]);
        }

        minRentInput.addEventListener("change", updateSliderFromInput);
        maxRentInput.addEventListener("change", updateSliderFromInput);
    })
    .catch(error => {
        console.error('Error fetching filter options:', error);
    });
}


// Populate the filter options dynamically
function populateFilters(filters) {
    // Property Type
    filters.propertyType.forEach(type => {
        const checkbox = document.createElement('div');
        checkbox.innerHTML = `
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="propertyType-${encodeURIComponent(type)}" name="propertyType" value="${encodeURIComponent(type)}">
                <label for="ex-check-1" class="form-check-label">${type}</label>
            </div>
        `;
        propertyTypeFilters.appendChild(checkbox);
    });

    // City Dropdown
    const cityDropdown = document.createElement('select');
    cityDropdown.classList.add('form-select');
    cityDropdown.id = 'city-dropdown';
    cityDropdown.innerHTML = `<option value="">Select City</option>`;
    filters.city.forEach(city => {
        const option = document.createElement('option');
        option.value = encodeURIComponent(city);
        option.textContent = city;
        cityDropdown.appendChild(option);
    });
    cityFilters.appendChild(cityDropdown);

    // Beds
    filters.beds.forEach(bed => {
        const checkbox = document.createElement('div');
        if(bed == 0) {
            checkbox.innerHTML = `
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="beds-${encodeURIComponent(bed)}" name="beds" value="${encodeURIComponent(bed)}">
                <label for="ex-check-1" class="form-check-label">Studio</label>
            </div>
        `;
        } else {
            checkbox.innerHTML = `
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="beds-${encodeURIComponent(bed)}" name="beds" value="${encodeURIComponent(bed)}">
                <label for="ex-check-1" class="form-check-label">${bed} Beds</label>
            </div>
        `;
        }
        
        bedsFilters.appendChild(checkbox);
    });

    // Baths
    filters.baths.forEach(bath => {
        const checkbox = document.createElement('div');
        checkbox.innerHTML = `
            <div class="form-check">
                <input type="checkbox" class="form-check-input" id="baths-${encodeURIComponent(bath)}" name="baths" value="${encodeURIComponent(bath)}">
                <label for="ex-check-1" class="form-check-label">${bath} Baths</label>
            </div>
        `;
        bathsFilters.appendChild(checkbox);
    });
}


// Create and show the listings and map markers
function fetchListings(filters = {}, sort = 'price_desc', page = 1) {
    const url = new URL('<?php echo $nestedLocation; ?>resources/helpers/listings-handler.php', window.location.href);
    const params = new URLSearchParams();

    console.log("Sending filters:", filters); // Debugging: Check what's being sent


    // Adding filters to params and encoding them only once
    for (let key in filters) {
        if (Array.isArray(filters[key]) && filters[key].length > 0) {
            params.append(key, filters[key].join(',')); // Join array elements if it's an array
        } else if (filters[key]) {
            params.append(key, filters[key]); // Directly append scalar values
        }
    }

    // Adding sorting and pagination params
    params.append('sort', sort);
    params.append('page', page);

    // Make AJAX request to get listings
    fetch(url + '?' + params.toString(), {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.listings && data.listings.length > 0) {

                totalPages = data.total_pages;

                // Step 1: Smoothly scroll to top
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });

                // Step 2: Wait for scroll to complete before removing old listings
                let scrollCheck = setInterval(() => {
                    if (window.scrollY === 0) {
                        clearInterval(scrollCheck); // Stop checking once scrolled to top

                        // Step 3: Fade-out animation for old listings
                        document.querySelectorAll('.listing-card').forEach(card => {
                            card.classList.add('fade-out');
                        });

                        setTimeout(() => {
                    listingsContainer.innerHTML = ''; // Remove old listings after animation

                    $(".totalCount").html(data.total_count + " Results");

                    data.listings.forEach((listing, index) => {

                        const listingCard = document.createElement('div');
                        listingCard.classList.add('col-md-4', 'listing-card');

                        const photoUrl = listing.photos && Array.isArray(listing.photos) && listing.photos.length > 0
                            ? listing.photos[0]
                            : '<?php echo str_replace("../", "/..", $nestedLocation); ?>/resources/img/real-estate/top-properties/02.jpg';

                        listingCard.innerHTML = `
                            <div class="card card-hover mb-4 mx-1">
                                <div style="height: 250px;">
                                    <div class="card-img-top card-img-hover listing-image-preview" style="background-image: url('${photoUrl}');" alt="Listing Image">
                                    </div>
                                </div>
                                <div class="card-body position-relative pb-3">
                                    <h4 class="mb-1 fs-xs fw-normal text-uppercase text-primary">For rent</h4>
                                    <h3 class="h6 mb-2 fs-base"><a class="nav-link stretched-link" target="_blank" href="${listing.btnUrl}"</a></h3>
                                    <h3 class="h6 mb-2 fs-base"><a class="nav-link stretched-link" target="_blank" href="${listing.btnUrl}">${listing.propertyType} in ${listing.city}</a></h3>
                                    <p class="mb-2 fs-sm text-muted">${listing.address}</p>
                                    <p class="mb-2 fs-sm text-muted">${listing.city}, ${listing.state} ${listing.zip}</p>
                                    <p class="mb-2 fs-sm text-muted">Availability: ${listing.dateAvailable}</p>
                                    <div class="d-flex align-items-center justify-content-center mx-3 pt-2 text-nowrap">
                                        <span class="d-inline-block mx-1 px-2 fs-sm">
                                            <i class="fi-bed me-1 mt-n1 fs-lg text-primary"></i>${listing.beds} Beds
                                        </span>
                                        <span class="d-inline-block mx-1 px-2 fs-sm">
                                            <i class="fi-bath me-1 mt-n1 fs-lg text-primary"></i>${listing.baths} Baths
                                        </span>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-center mx-3 pt-3 pb-2 text-nowrap">
                                        <div class="fw-bold fs-sm">
                                            <i class="fi-cash mt-n1 me-2 lead align-middle fs-lg text-primary"></i>Rent: $${listing.rentAmount}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        `;

                        listingsContainer.appendChild(listingCard);


                                // Step 5: Delay slide-in animation until after scrolling finishes
                                setTimeout(() => {
                                    listingCard.style.opacity = "1"; // Make visible before animation
                                    listingCard.classList.add('slide-in');
                                }, 100 + (index * 100)); // Staggered effect
                            });

                            updatePagination();
                        }, 300); // Delay removal of listings for fade-out effect
                    }
                }, 50); // Check every 50ms if scroll is complete

            } else {
                listingsContainer.innerHTML = '<p>No listings found.</p>';
                paginationContainer.style.display = 'none'; // Hide pagination when no listings are found

            }
        })
        .catch(error => {
        console.error('Error fetching listings:', error);
        listingsContainer.innerHTML = `
            <div class="alert alert-danger text-center" role="alert">
                <strong>Oops!</strong> Something went wrong while loading the listings.
            </div>
        `;
        document.body.scrollTop = document.documentElement.scrollTop = 0;
        paginationContainer.style.display = 'none'; // Hide pagination when no listings are found
    });
}

document.getElementById('apply-filters').addEventListener('click', () => {
  paginationContainer.style.display = 'block';  // Ensure pagination is visible

    currentPage = 1; // Reset to first page
    fetchListings(getSelectedFilters(), document.getElementById('sort-options').value, 1);

});

document.querySelector('#sort-options').addEventListener("change", function() {
    $("#apply-filters").click();
});

// Handle pagination
function updatePagination() {
    document.body.scrollTop = document.documentElement.scrollTop = 0;

    paginationContainer.innerHTML = '';

    // First page button
    const firstPageButton = document.createElement('button');
    firstPageButton.textContent = 'First';
    firstPageButton.classList.add('btn', 'btn-sm', 'btn-secondary', 'm-1');
    firstPageButton.onclick = () => {
        currentPage = 1;
        updateUrlAndFetch(currentPage);
    };
    paginationContainer.appendChild(firstPageButton);

    // Previous pages (3 pages before the current page, with ellipsis if needed)
    if (currentPage > 3) {
        const ellipsisPrev = document.createElement('button');
        ellipsisPrev.textContent = '...';
        ellipsisPrev.classList.add('btn', 'btn-sm', 'btn-secondary', 'm-1', 'disabled');
        paginationContainer.appendChild(ellipsisPrev);
    }

    const startPage = Math.max(1, currentPage - 2);
    for (let i = startPage; i < currentPage; i++) {
        const pageButton = document.createElement('button');
        pageButton.textContent = i;
        pageButton.classList.add('btn', 'btn-sm', 'btn-secondary', 'm-1');
        pageButton.onclick = () => {
            currentPage = i;
            updateUrlAndFetch(currentPage);
        };
        paginationContainer.appendChild(pageButton);
    }

    // Current page button (highlighted)
    const currentPageButton = document.createElement('button');
    currentPageButton.textContent = currentPage;
    currentPageButton.classList.add('btn', 'btn-sm', 'btn-primary', 'm-1');  // Highlighted button for the current page
    paginationContainer.appendChild(currentPageButton);

    // Next pages (3 pages after the current page)
    const endPage = Math.min(totalPages, currentPage + 2);
    for (let i = currentPage + 1; i <= endPage; i++) {
        const pageButton = document.createElement('button');
        pageButton.textContent = i;
        pageButton.classList.add('btn', 'btn-sm', 'btn-secondary', 'm-1');
        pageButton.onclick = () => {
            currentPage = i;
            updateUrlAndFetch(currentPage);
        };
        paginationContainer.appendChild(pageButton);
    }

    // Ellipsis for next pages if there are more after the displayed pages
    if (currentPage < totalPages - 2) {
        const ellipsisNext = document.createElement('button');
        ellipsisNext.textContent = '...';
        ellipsisNext.classList.add('btn', 'btn-sm', 'btn-secondary', 'm-1', 'disabled');
        paginationContainer.appendChild(ellipsisNext);
    }

    // Last page button
    const lastPageButton = document.createElement('button');
    lastPageButton.textContent = 'Last';
    lastPageButton.classList.add('btn', 'btn-sm', 'btn-secondary', 'm-1');
    lastPageButton.onclick = () => {
        currentPage = totalPages;
        updateUrlAndFetch(currentPage);
    };
    paginationContainer.appendChild(lastPageButton);
}

function updateUrlAndFetch(page) {
    // Update the URL without reloading the page
    const url = new URL(window.location.href);
    url.searchParams.set('page', page); // Set the page parameter
    window.history.pushState({}, '', url); // Update the browser's URL

    // Fetch listings for the updated page
    fetchListings(getSelectedFilters(), document.getElementById('sort-options').value, page);
}

window.addEventListener('popstate', function() {
    // Extract the current page from the URL when back/forward is clicked
    const urlParams = new URLSearchParams(window.location.search);
    const page = parseInt(urlParams.get('page')) || 1; // Default to 1 if not found
    currentPage = page;

    // Fetch listings for the updated page and update the pagination
    // fetchListings(getSelectedFilters(), document.getElementById('sort-options').value, currentPage);
    updatePagination();  // Re-render pagination buttons based on the updated page
});


function validateFilters(filters) {
    if (filters.minRent < 0 || filters.maxRent < filters.minRent) {
        alert("Invalid rent range.");
        return false;
    }
    return true;
}

// Get selected filters
function getSelectedFilters() {
    const filters = {};
    const checkboxes = document.querySelectorAll('#filters-form input[type="checkbox"]:checked');
    checkboxes.forEach(checkbox => {
        if (!filters[checkbox.name]) {
            filters[checkbox.name] = [];
        }
        filters[checkbox.name].push(checkbox.value);
    });

    // Get selected city from dropdown
    const selectedCity = document.getElementById('city-dropdown').value;
    if (selectedCity) {
        filters.city = [selectedCity];
    }

// Get rent range values from manual inputs
const minRentInput = document.getElementById('minRentInput');
const maxRentInput = document.getElementById('maxRentInput');

filters.minRent = parseInt(minRentInput.value, 10);
filters.maxRent = parseInt(maxRentInput.value, 10);


    // Pets filter (boolean values)
    filters.dogs = document.getElementById('dogs').checked ? 1 : 0;
    filters.cats = document.getElementById('cats').checked ? 1 : 0;

    return filters;
}




// Initial load with dynamic filters and listings
fetchFilterOptions();
fetchListings({}, 'price_desc', currentPage);
</script>

<!-- Footer-->
<?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

<!-- Filters sidebar toggle button (mobile)-->
<button class="btn btn-primary btn-sm w-100 rounded-0 fixed-bottom d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#filters-sidebar"><i class="fi-filter me-2"></i>Filters & Sorting</button>

<!-- Back to top button-->
<a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

<!-- Vendor scripts-->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="<?php echo str_replace('../', '/..', $nestedLocation); ?>/resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo str_replace('../', '/..', $nestedLocation); ?>/resources/vendor/simplebar/dist/simplebar.min.js"></script>
<script src="<?php echo str_replace('../', '/..', $nestedLocation); ?>/resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
<!-- Main theme script-->
<script src="<?php echo str_replace('../', '/..', $nestedLocation); ?>/resources/js/theme.js"></script>

</body>
</html>
