<?php

// Path - Info
$nestedLocation = '../../';

// Session data
session_start();
$sessionID = $_SESSION['ID'];

// Auto load classes
include($nestedLocation . 'resources/includes/class-autoload.inc.php');

// Set time
date_default_timezone_set("America/New_York");
$date = date('Y-m-d H:i:s');

// DB Connection
$DB = new DBConnect();

// reCaptcha verification
function reCaptchaVerification() {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, [
        'secret' => $privatekey,
        'response' => $_POST['g-recaptcha-response'],
        'remoteip' => $_SERVER['REMOTE_ADDR']
    ]);

    $resp = json_decode(curl_exec($ch));
    curl_close($ch);

    if ($resp->success) {
        // Success
    } else {
        // failure
    }
}

// DB Connection Instance
if($_POST['formType'] == 1) {
    if(isset($_POST['email'], $_POST['location'])) {
        $sql = "SELECT * FROM form_data WHERE sessionID = $sessionID";
        $stmt = $DB->connect()->query($sql);
        $row = $stmt->fetch();
        if($row) {
            $statement = $DB->connect()->prepare("UPDATE form_data SET email=:email, location=:location WHERE sessionID=:sessionID");
            $statement->execute([
                'email' => $_POST['email'],
                'location' => $_POST['location'],
                'sessionID' => $sessionID,
            ]);
        } else {
            $statement = $DB->connect()->prepare("INSERT INTO form_data (sessionID, formType, ipAddress, email, location)
                VALUES (:sessionID, :formType, :ipAddress, :email, :location)");
            $statement->execute([
                'formType' => 1,
                'sessionID' => $_SESSION['ID'],
                'ipAddress' => $_SERVER['REMOTE_ADDR'],
                'email' => $_POST['email'],
                'location' => $_POST['location'],
            ]);
        }
    } 
} elseif($_POST['formType'] == 2) {
    if(isset($_POST['firstName'], $_POST['secondName'], $_POST['phoneNumber'])) {
        $statement = $DB->connect()->prepare("UPDATE form_data SET formType=:formType, firstName=:firstName, secondName=:secondName, phoneNumber=:phoneNumber WHERE sessionID=:sessionID");
        $statement->execute([
            'formType' => 2,
            'firstName' => $_POST['firstName'],
            'secondName' => $_POST['secondName'],
            'phoneNumber' => $_POST['phoneNumber'],
            'sessionID' => $sessionID,
        ]);
    }
} elseif($_POST['formType'] == 3) {
    if(isset($_POST['ownerStreet'], $_POST['ownerCity'], $_POST['ownerState'], $_POST['ownerZipCode'])) {
        $statement = $DB->connect()->prepare("UPDATE form_data SET formType=:formType, ownerStreet=:ownerStreet, ownerCity=:ownerCity, ownerState=:ownerState, ownerZipCode=:ownerZipCode WHERE sessionID=:sessionID");
        $statement->execute([
            'formType' => 3,
            'ownerStreet' => $_POST['ownerStreet'],
            'ownerCity' => $_POST['ownerCity'],
            'ownerState' => $_POST['ownerState'],
            'ownerZipCode' => $_POST['ownerZipCode'],
            'sessionID' => $sessionID,
        ]);
    }
} elseif($_POST['formType'] == 4) {
    if(isset($_POST['ownerPropertyStreet'], $_POST['ownerPropertyCity'], $_POST['ownerPropertyState'], $_POST['ownerPropertyZipCode'])) {
        $statement = $DB->connect()->prepare("UPDATE form_data SET formType=:formType, ownerPropertyStreet=:ownerPropertyStreet, ownerPropertyCity=:ownerPropertyCity, ownerPropertyState=:ownerPropertyState, ownerPropertyZipCode=:ownerPropertyZipCode WHERE sessionID=:sessionID");
        $statement->execute([
            'formType' => 3,
            'ownerPropertyStreet' => $_POST['ownerPropertyStreet'],
            'ownerPropertyCity' => $_POST['ownerPropertyCity'],
            'ownerPropertyState' => $_POST['ownerPropertyState'],
            'ownerPropertyZipCode' => $_POST['ownerPropertyZipCode'],
            'sessionID' => $sessionID,
        ]);
    }
} elseif($_POST['formType'] == 5) {
    if(isset($_POST['email'], $_POST['location'], $_POST['firstName'], $_POST['secondName'], $_POST['phoneNumber'], $_POST['message'])) {
       $statement = $DB->connect()->prepare("INSERT INTO contact_form_data (formType, ipAddress, email, location, firstName, secondName, phoneNumber, message, date)
               VALUES (:formType, :ipAddress, :email, :location, :firstName, :secondName, :phoneNumber, :message, :date)");
       $statement->execute([
           'formType' => 4,
           'ipAddress' => $_SERVER['REMOTE_ADDR'],
           'email' => $_POST['email'],
           'location' => $_POST['location'],
           'firstName' => $_POST['firstName'],
           'secondName' => $_POST['secondName'],
           'phoneNumber' => $_POST['phoneNumber'],
           'message' => $_POST['message'],
           'date' => $date,
       ]);
   }
}

var_dump($_POST);

?>