<?php

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);

// Get locations
$locations = $RMAPI->getFranchisees();

// Create a list of states we are present in
$validStates = [];
foreach($locations as $office) {
    if(array_key_exists($office['State'], $states)) {
        $tempArr = array(
          "Abbreviation" => $office['State'],
          "Name" => $states[$office['State']],
        );
        array_push($validStates, $tempArr);
        // $validStates[$office['State']] = $states[$office['State']];
    }
}
// hacky hacky fix to remove state duplicates
$validStates = array_map("unserialize", array_unique(array_map("serialize", $validStates)));
// var_dump($validStates);

// Set page parameters/meta
$pageType = 0;
$pageName = 'ACPM.Locations';
$pageTitle = 'Locations | All County Property Management';
$pageMetaDescription = 'With ' . count($locations) . ' locations across the U.S., All County services more than 30,000 residential properties—find a location nearest you to get started with an expert!';
$pageMetaKeyword = array(
  'property management office', 'about us', 'information about all county', 'all county members', 'all county managers', 'about all county'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

?>