<?php

// Auto load classes, lists, & pre-requisites.
include($nestedLocation . 'resources/includes/prerequisites.inc.php');
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// Create state info based on working directory
$dirr = dirname(__FILE__);
$eachDirr = explode('/', $dirr);
$stateName = ucfirst(end($eachDirr));

// API Instance
$RMAPI = new API(2);

// Grab all of our offices
$locations = $RMAPI->getFranchisees();

// Create a list of states we are present in
$validStates = [];
foreach($locations as $office) {
    if(array_key_exists($office['State'], $states)) {
        $tempArr = array(
          "Abbreviation" => $office['State'],
          "Name" => $states[$office['State']],
        );
        array_push($validStates, $tempArr);
        // $validStates[$office['State']] = $states[$office['State']];
    }
}
$validStates = array_map("unserialize", array_unique(array_map("serialize", $validStates)));

// Set page parameters/meta
$pageType = 0;
$pageName = 'ACPM.Locations';
$pageTitle = 'States | All County Property Management';
$pageMetaDescription = 'Rent your home the easy way. All County Property Management takes care of tenant screenings, payments, maintenance, and more—find an office near you.';
$pageMetaKeyword = array(
  'property management office', 'find a property management company', ' property management'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);


?>