<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);

// Config for franchise pages
$configFile = file_get_contents($officeNestedLocation . "config.json");
$config = json_decode($configFile, true);

// Get corresponding location from location data array
$locations = $RMAPI->getFranchisees();
foreach($locations as $location) {
  if($location['Name'] == $config['Name']) {
    $locationData = $location;
  }
}

// Set page parameters/meta
$pageType = 1;
$pageName = 'About';
$pageTitle = 'About - ' . str_replace(" Property Management", "", $locationData['Franchise Name']) . ' in ' . $locationData['Primary City'];
$pageMetaDescription = "Get to know the property management professionals at All County's office in " . $locationData['Primary City'] . ', ' . $states[$locationData['State']] . '.';
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'reviews', 'latest reviews', 'google reviews', 'bing reviews', 'yelp reviews', 'rating'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Fetch data from OfficeManager
// WARNING enable this instead of the CURL below once we are in production
$officeData = new FetchOfficeData();
$latestOfficeImage = $officeData->getLatestImageData($locationData['Name'], 1);
$latestOfficeBG = $officeData->getLatestImageData($locationData['Name'], 2);
$latestOfficeBio = str_replace('<h1>&nbsp;</h1>', '', $officeData->getLatestBioData($locationData['Name'], 2));

?>