<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// // API Instance
// $RMAPI = new API(2);

// // Config for franchise pages
// $configFile = file_get_contents($officeNestedLocation . "config.json");
// $config = json_decode($configFile, true);

// // Get corresponding location from location data array
// $locations = $RMAPI->getFranchisees();
// foreach($locations as $location) {
//   if($location['Name'] == $config['Name']) {
//     $locationData = $location;
//   }
// }

// Get location based on URL
$locations = new Locations;
$locationData = $locations->getLocationFromURL();

// Set page parameters/meta
$pageType = 1;
$pageName = 'Rentals';
$pageTitle = 'Homes for rent in ' . $locationData['primary_city'] . ', ' . $locationData['state'] . ' - ' . str_replace(" Property Management", "", $locationData['franchise_name']);
$pageMetaDescription = 'Find homes for rent in ' . $locationData['primary_city'] . ', ' . $locationData['state'] . ' managed by the real estate professionals at All County Property Management.';
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['franchise_name']), $locationData['franchise_name'], 'rentals', 'available rentals', 'apartments for rent', 'homes for rent'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Sanitize and validate user inputs (filters, page, etc.)
function sanitize_input($data) {
  return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// Validate page number
$page = 1; // Default
if (isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0) {
  $page = (int) $_GET['page'];
}

// Sort parameter validation
$valid_sort_options = ['price_asc', 'price_desc', 'date_soonest', 'date_latest'];
$sort = 'price_desc'; // Default
if (isset($_GET['sort']) && in_array($_GET['sort'], $valid_sort_options)) {
  $sort = sanitize_input($_GET['sort']);
}
?>