<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);

// Config for franchise pages
$configFile = file_get_contents($officeNestedLocation . "config.json");
$config = json_decode($configFile, true);

// Get corresponding location from location data array
$locations = $RMAPI->getFranchisees();
foreach($locations as $location) {
  if($location['Name'] == $config['Name']) {
    $locationData = $location;
  }
}

// Set page parameters/meta
$pageType = 1;
$pageName = 'Rentals';
$pageTitle = 'Rental in ' . $locationData['Primary City'] . ' - ' . str_replace(" Property Management", "", $locationData['Franchise Name']);
$pageMetaDescription = 'Rental in ' . $locationData['Primary City'] . ', ' . $locationData['State'] . ', profesionally managed by ' . str_replace(" Property Management", "", $locationData['Franchise Name']) . '.';
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'rental', 'available rental', 'apartment for rent', 'home for rent'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Fetch data from OfficeManager
$officeData = new FetchOfficeData();
$latestOfficeImage = $officeData->getLatestImageData($locationData['Name'], 1);
$latestOfficeBG = $officeData->getLatestImageData($locationData['Name'], 2);

?>