<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);
$officeData = new FetchOfficeData();

// Config for franchise pages
$configFile = file_get_contents($officeNestedLocation . "config.json");
$config = json_decode($configFile, true);

// Get corresponding location from location data array
$locations = $RMAPI->getFranchisees();
foreach($locations as $location) {
  if($location['Name'] == $config['Name']) {
    $locationData = $location;
  }
}

// Set page parameters/meta
$pageType = 1;
$pageName = 'Residents';
$pageTitle = $locationData['Primary City'] . " Resident Portal - " . str_replace(" Property Management", "", $locationData['Franchise Name']);
$pageMetaDescription = "Pay rent and request maintenance using All County Property Management's online portal for " . $locationData['Primary City'] . ' residents.';
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'resident portal', 'online portal', 'pay rent', 'portal', 'maintenance', 'maintenance request', 'resident information', 'online payment'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);

// Generate maintenance link
if(isset($locationData['MaintenanceLink'])) {
  $maintenanceLink = $locationData['MaintenanceLink'];
} else {
  // $maintenanceLink = "https://acpm.twa.rentmanager.com/?locationID=" . $locationData['LocationID'];
  $maintenanceLink = 0;
}

// Get resource pages
// $resourcePages = $officeData->getResourcePage(0, $_SESSION['currentLocationDetailed'][0]['Name']);

// Get owner/resident/realtor resources
// $ownerResources = $officeData->getOwnerResidentResource(0, 1, $_SESSION['currentLocationDetailed'][0]['Name']);
$residentResources = $officeData->getOwnerResidentResource(0, 2, $locationData['Name']);
// $realtorResources = $officeData->getOwnerResidentResource(0, 3, $_SESSION['currentLocationDetailed'][0]['Name']);

?>