<?php

// Auto load classes & lists
include($nestedLocation . 'resources/includes/class-autoload.inc.php');
include($nestedLocation . 'resources/includes/keyword.list.inc.php');

// API Instance
$RMAPI = new API(2);

// Config for franchise pages
$configFile = file_get_contents($officeNestedLocation . "config.json");
$config = json_decode($configFile, true);

// Get corresponding location from location data array
$locations = $RMAPI->getFranchisees();
foreach($locations as $location) {
  if($location['Name'] == $config['Name']) {
    $locationData = $location;
  }
}

// Set page parameters/meta
$pageType = 1;
$pageName = 'Resource Page';
$pageTitle = 'Resources for ' . str_replace(" Property Management", "", $locationData['Franchise Name']) . ' in ' . $locationData['Primary City'];
$pageMetaDescription = 'All County is a top-rated property management company with over ' . count($locations) . ' locations nationwide—read the latest testimonials for our ' . $locationData['Primary City'] . " location.";
$pageMetaKeyword = array(
  str_replace(" Property Management", "", $locationData['Franchise Name']), $locationData['Franchise Name'], 'testimonials', 'latest testimonials', 'google testimonials', 'bing testimonials', 'yelp testimonials', 'rating'
);
$pageMetaKeywordMerged = array_merge($pageMetaKeyword, $keywordListBase);
?>