<?php

// Determine dev mode
if(strpos($_SERVER['SERVER_NAME'], 'aquaactionfl') !== false || strpos($_SERVER['SERVER_NAME'], 'localhost') !== false) {
    $DEV_MODE = 1;
} else {
    $DEV_MODE = 0;
}

// Metadata variables
$siteName = 'ACPM';
$authorName = "Jorge Jimenez";
$siteDescription = 'Rent your home the easy way. All County Property Management takes care of tenant screenings, payments, maintenance, and more—find an office near you.';
$domain = 'allcountyprop.com';
$ACPM_VER = 'D.20230115';
$applicationVersion = '1.15';

// Generate canonical URL
$fullurl = ($_SERVER['REQUEST_URI']);
$trimmed = trim($fullurl, ".php");
$canonicalUrl = rtrim($trimmed, '/') . '/';
if($DEV_MODE) {
    $baseUrl = "https://development.allcountyapplications.com/allcountyprop.com";
} else {
    $baseUrl = "https://www.allcountyprop.com";
}

// Redirects for primary city changes
if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on')   
    $url = "https://";   
else  
    $url = "http://";   
// Append the host(domain name, ip) to the URL.   
$url.= $_SERVER['HTTP_HOST'];   
// Append the requested resource location to the URL   
$url.= $_SERVER['REQUEST_URI'];
// determine if a redirect is necessary
$redirect = 0;

///////////////////// OFFICE PAGE REDIRECTS /////////////////////
// OFF - NEO LC - fairview-park -> lakewood
if(str_contains($url, 'fairview-park')) {
    $url = str_replace('fairview-park', 'lakewood', $url);
    $redirect = 1;
}
// OFF- CAPITAL - austin -> sunset-valley
// if(str_contains($url, 'austin')) {
//     $url = str_replace('austin', 'sunset-valley', $url);
//     $redirect = 1;
// }
// OFF - Maui - fairview-park -> home page
if(str_contains($url, 'maui')) {
    $url = str_replace('/locations/hawaii/maui/', '', $url);
    $redirect = 1;
}
///////////////////// REGIONAL PAGE REDIRECTS /////////////////////
// REG - Los Angeles
if(str_contains($url, 'locations/california/los-angeles')) {
    $url = str_replace('locations/california/los-angeles/', 'region/los-angeles-property-management', $url);
    $redirect = 1;
}
// REG - Miami
if(str_contains($url, 'locations/florida/miami')) {
    $url = str_replace('locations/florida/miami/', 'region/miami-property-management', $url);
    $redirect = 1;
}
// REG - Orlando
if(str_contains($url, 'locations/florida/orlando')) {
    $url = str_replace('locations/florida/orlando/', 'region/orlando-property-management', $url);
    $redirect = 1;
}
// REG - Tampa
if(str_contains($url, 'locations/florida/tampa-bay')) {
    $url = str_replace('locations/florida/tampa-bay/', 'region/tampa-property-management', $url);
    $redirect = 1;
}
// REG - Atlanta
if(str_contains($url, 'locations/georgia/atlanta')) {
    $url = str_replace('locations/georgia/atlanta/', 'region/atlanta-property-management', $url);
    $redirect = 1;
}
// REG - Chicago
if(str_contains($url, 'locations/illinois/chicago')) {
    $url = str_replace('locations/illinois/chicago/', 'region/chicago-property-management', $url);
    $redirect = 1;
}
// REG - Cleveland
if(str_contains($url, 'locations/ohio/cleveland')) {
    $url = str_replace('locations/ohio/cleveland/', 'region/cleveland-property-management', $url);
    $redirect = 1;
}
// REG - Dallas
if(str_contains($url, 'locations/texas/dallas')) {
    $url = str_replace('locations/texas/dallas/', 'region/dallas-property-management', $url);
    $redirect = 1;
}
// REG - Houston
if(str_contains($url, 'locations/texas/houston')) {
    $url = str_replace('locations/texas/houston/', 'region/houston-property-management', $url);
    $redirect = 1;
}
// REG - San Antonio
if(str_contains($url, 'locations/texas/san-antonio')) {
    $url = str_replace('locations/texas/san-antonio/', 'region/san-antonio-property-management', $url);
    $redirect = 1;
}

// Execute redirect if needed
if($redirect) {
    header("HTTP/1.1 301 Moved Permanently");
    header("Location: $url");
    exit();
}

// Set time
date_default_timezone_set("America/New_York");
$date = date('Y-m-d H:i:s');

// Add session data - not working correctly, fix later
session_start();
if(!isset($_SESSION['ID'])) {
    $_SESSION['ID'] = rand('1000000', '9999999');
}
// $accessBlob = array("page" => $pageTitle, "accessTime" => $date);
// Add last location data
// if(is_array($_SESSION['lastVisitedPage'])) { array_push($_SESSION['lastVisitedPage'], $accessBlob); } else { $_SESSION['lastVisitedPage'] = $accessBlob; };
// Add interested franchise locations data
// if($pageType) {
//     if(is_array($_SESSION['interestedLocations'])) {
//         if(!in_array($locationData['Name'], $_SESSION['interestedLocations'])) {
//             array_push($_SESSION['interestedLocations'], $locationData['Name']); 
//         }
//     } else { 
//         $_SESSION['interestedLocations'] = $locationData['Name']; 
//     };
// }

// State lookup list
$states = [];
$states['AL'] = 'Alabama';
$states['AK'] = 'Alaska';
$states['AZ'] = 'Arizona';
$states['AR'] = 'Arkansas';
$states['CA'] = 'California';
$states['CO'] = 'Colorado';
$states['CT'] = 'Conneticut';
$states['DC'] = 'Washington, DC';
$states['DE'] = 'Delaware';
$states['FL'] = 'Florida';
$states['GA'] = 'Georgia';
$states['HI'] = 'Hawaii';
$states['ID'] = 'Idaho';
$states['IL'] = 'Illinois';
$states['IN'] = 'Indiana';
$states['IA'] = 'Iowa';
$states['KS'] = 'Kansas';
$states['KY'] = 'Kentucky';
$states['LA'] = 'Lousiana';
$states['ME'] = 'Maine';
$states['MD'] = 'Maryland';
$states['MA'] = 'Massachusetts';
$states['MI'] = 'Michigan';
$states['MN'] = 'Minnesota';
$states['MS'] = 'Mississippi';
$states['MO'] = 'Missouri';
$states['MT'] = 'Montana';
$states['NE'] = 'Nebraska';
$states['NV'] = 'Nevada';
$states['NH'] = 'New Hampshire';
$states['NJ'] = 'New Jersey';
$states['NM'] = 'New Mexico';
$states['NY'] = 'New York';
$states['NC'] = 'North Carolina';
$states['ND'] = 'North Dakota';
$states['OH'] = 'Ohio';
$states['OK'] = 'Oklahoma';
$states['OR'] = 'Oregon';
$states['PA'] = 'Pennsylvania';
$states['RI'] = 'Rhode Island';
$states['SC'] = 'South Carolina';
$states['SD'] = 'South Dakota';
$states['TN'] = 'Tennessee';
$states['TX'] = 'Texas';
$states['UT'] = 'Utah';
$states['VT'] = 'Vermont';
$states['VA'] = 'Virginia';
$states['WA'] = 'Washington';
$states['WV'] = 'West Virginia' ;
$states['WI'] = 'Wisconsin' ;
$states['WY'] = 'Wyoming';

// Region state lookup list
$regions = [];
$regions['Georgia'] = 'Atlanta';
$regions['Florida'] = ['Tampa', 'Orlando', 'Miami'];
$regions['Austin'] = 'Austin';
$regions['Dallas'] = 'Dallas';
$regions['San Antonio'] = 'Houston';
$regions['Houston'] = 'San Antonio';
$regions['Los Angeles'] = 'Los Angeles';
$regions['Chicago'] = 'Chicago';
$regions['Cleveland'] = 'Cleveland';
$regions['Denver'] = 'Denver';



// Load office config/data from DB
// $officeManager = new OfficeManager();


?>