    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Portal Modal -->
      <?php include_once($nestedLocation . 'resources/layouts/modals/portal.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5 pt-4 pb-lg-5">
        <div class="row g-0 mt-n3 pt-sm-5">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-4">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Owners</li>
              </ol>
            </nav>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Owners</h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">View information about your rental property and see funds available to you.</p>
              </div>
            </div>
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>
            <!-- Option cards-->
            <section class="container mb-5 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <!-- Item-->
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0">Owner Portal</h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Current owners of properties managed by <b><?php echo $locationData['Franchise Name']; ?></b> can login to see information about their rental properties.</span>
                      
                    </div>
                    <div class="card-footer">
                      <a class="" href="#portal-modal" data-bs-toggle="modal"><h3 class="mt-4 h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Sign in</h3></a>
                    </div>
                  </div>
                </div>

              </div>
            </section>


            <?php if(!empty($ownerResources)) { ?>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-2 pb-sm-3">
              <h3 class="h3 mb-sm-0">Resources & Forms</h3>
            </div>
            <!-- <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Resources and forms for owners.</p>
              </div>
            </div> -->
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <section class="container mb-4 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <?php foreach($ownerResources as $ownerResource) { ?>
                <!-- Item-->
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0"><?php echo $ownerResource['resource_title'] ?></h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body"><?php echo $ownerResource['resource_content'] ?></span>
                    </div>
                    <div class="card-footer">
                        <a target="_blank" href="<?php echo $ownerResource['resource_button'] ?>"><h3 class="mt-4 h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">View</h3></a>
                    </div>
                  </div>
                </div>
                <?php } ?>
              </div>
            </section>
            <?php } ?>

            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h3 class="h3 mb-sm-0">Videos</h3>
            </div>
            <!-- <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Video resources for owners.</p>
              </div>
            </div> -->
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <section class="container mb-5 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <!-- Resource - Video -->
                <div class="col-md-6">
                  <div class="card gallery">
                    <div style="padding:56.25% 0 0 0;position:relative;">
                      <iframe class="rounded" src="https://player.vimeo.com/video/1079465079?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Property Management services video"></iframe>
                    </div>
                    <script src="https://player.vimeo.com/api/player.js"></script>
                    <div class="card-body">
                      <h5 class="card-title">Owner Services Video</h5>
                      <p class="card-text fs-sm text-muted">Video explaining the various time saving services we provide owners.</p>
                    </div>
                  </div>
                </div>
              </div>
            </section>


          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>