
    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5 pt-4 pb-lg-5">
        <div class="row g-0 mt-n3 pt-sm-5">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-4">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Free Quote</li>
              </ol>
            </nav>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Free Quote</h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Receive a completely free quote from our professional property management team.</p>
              </div>
            </div>
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <!-- Hero-->
            <section class="container mb-3 mt-sm-5">
              <div class="row align-items-md-start align-items-center gy-4">
                <div class="col-lg-5 col-md-6">
                  <div class="mx-md-0 mx-auto mb-md-2 mb-2 pb-md-2 text-md-start text-center" style="max-width: 416px;">
                    <!-- <h1 class="mb-4">Get in touch!</h1> -->
                  </div>
                  <img class="d-block mx-auto pb-4" src="<?php echo $nestedLocation; ?>resources/img/real-estate/illustrations/contact.svg" alt="Illustration">
                  <p class="display-6 mb-5 fs-lg text-muted mt-5 text-center">If you need help with a maintenance request or need resident assistance please <a class="text-primary text-decoration-none" href="<?php echo $officeNestedLocation; ?>residents/">click here</a> instead.</p>
                </div>
                <div class="col-md-6 offset-lg-1">
                  <div class="card border-0 bg-secondary p-sm-3 p-2">
                    <div class="card-body m-1">
                      <div class="w-100" id="#guestCard1" > 
                        <div class="guestCardFieldsUAContainer w-100">
                            <div class="text-center"><h4>Fill out this form to receive a free quote.</h4></div>
                            <!-- The form fields will be generated here -->
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </section>



          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

    <!-- Contact form validation -->
    <script>
      function checkContactForm() {
        // check if valid email input
        if(validateName("#firstName") & validateName("#secondName") & validateEmail("#email"), validatePhone("#phoneNumber", validateName("#message"))) {
          // // log and mark successful input
          console.log('valid entries');
          $('#firstName, #secondName, #email, #phoneNumber, #message').removeClass('bg-faded-danger');
          $('#invalid-alert').addClass('d-none');
          // $('#firstName, #secondName, #email, #phoneNumber, #message').addClass('bg-faded-success');
          // // submit data to ajax processor
          let dataPacketContactForm =  {};
          dataPacketContactForm['formType'] = 4;
          dataPacketContactForm['firstName'] = $('#firstName').val();
          dataPacketContactForm['secondName'] = $('#secondName').val();
          dataPacketContactForm['email'] = $('#email').val();
          dataPacketContactForm['location'] = "<?php echo $locationData['Name']; ?>";
          dataPacketContactForm['phoneNumber'] = $('#phoneNumber').val();
          dataPacketContactForm['message'] = $('#message').val();
          submitDataPacket(dataPacketContactForm);
          console.log(dataPacketContactForm);
          // trigger loader
          $(".page-loading").addClass('active');
          // wait, remove loader, and clear inputs
          setTimeout(function () {
            $(':input').val('');
            $('#success-alert').removeClass('d-none');
            $(".page-loading").removeClass('active');
            // $('#firstName, #secondName, #email, #phoneNumber, #message').removeClass('bg-faded-success');
            $('#firstName, #secondName, #email, #phoneNumber, #message').removeClass('bg-faded-danger');
          }, 1000);
        } else {
          // log and mark unsuccessful input
          console.log('invalid entries');
          $('#firstName, #secondName, #email, #phoneNumber, #message').removeClass('bg-faded-success');
          $('#invalid-alert').removeClass('d-none');
          $('#firstName, #secondName, #email, #phoneNumber, #message').addClass('bg-faded-danger');
        }
      }

      
      // Validators
      function validateName(inputName) {
        if($(inputName).val().length != 0){
            return 1;
        }
      }
      function validatePhone(inputPhone) {
        let PhoneNumberCell = $(inputPhone).val();
        let patternPhoneNumberCell =  /^\(?([0-9]{3})\s*\)?[-. ]?([0-9]{3})[-. ]?([0-9]{4})$/;
        if(patternPhoneNumberCell.test(PhoneNumberCell)) {
            return 1;
        }
      }
      function validateEmail(inputName) {
        let Email = $(inputName).val();
        let patternEmail = /\S+@\S+\.\S+/;
        if(patternEmail.test(Email)) {
            return 1;
        }
      }

      // Data ajax processor
      function submitDataPacket(data) {
        $.ajax({
            url: "<?php echo $nestedLocation; ?>resources/helpers/form.handler.php",
            type: "post",
            data: data ,
            success: function (response) {
              console.log(response);
            },
            error: function(jqXHR, textStatus, errorThrown) {
              console.log(textStatus, errorThrown);
            }
        });
      }
    </script>