    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5 pt-4 pb-lg-5">
        <div class="row g-0 mt-n3 pt-sm-5">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-4">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Realtors</li>
              </ol>
            </nav>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Realtors</h1>
            </div>
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <?php if(!empty($realtorResources)) { ?>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-2 pb-sm-3">
              <h3 class="h3 mb-sm-0">Resources & Forms</h3>
            </div>
            <!-- <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Resources and forms for realtors.</p>
              </div>
            </div> -->
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <section class="container mb-4 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <?php foreach($realtorResources as $realtorResource) { ?>
                <!-- Item-->
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0"><?php echo $realtorResource['resource_title'] ?></h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body"><?php echo $realtorResource['resource_content'] ?></span>
                    </div>
                    <div class="card-footer">
                        <a target="_blank" href="<?php echo $realtorResource['resource_button'] ?>"><h3 class="mt-4 h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">View</h3></a>
                    </div>
                  </div>
                </div>
                <?php } ?>
              </div>
            </section>
            <?php } ?>


            <!-- Option cards-->
            <section class="container mb-5 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <!-- Resource - Video -->
                <div class="col-md-6">
                  <div class="card gallery">
                    <div style="padding:56.25% 0 0 0;position:relative;">
                      <iframe class="rounded" src="https://player.vimeo.com/video/460690725?h=8e799b9d49&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Downloading the FSS Mobile App"></iframe>
                    </div>
                    <script src="https://player.vimeo.com/api/player.js"></script>
                    <div class="card-body">
                      <h5 class="card-title">Realtor Video</h5>
                      <p class="card-text fs-sm text-muted">
                        At All County® we know that Realtors® are essential to our success. That's why we financially reward Realtors® that send business our way. Plus you can rest assured that All County® protects your client lead by referring the client back to you when they decide to buy or sell. This is because at All County® our sole focus is property management and we do not list or sell properties
                        <br><br>We have over twenty-five years of experience in the property management business, and we are experts at everything from marketing and tenant screening to lease negotiation and rent collection. Please remember us when your next client wants to avoid the hassles of property management.
                        <br><br>Realtors® who place their clients in All County's® care find that working with us is a win-win partnership. Please watch the video below to find out more about our current referral fees and start benefiting from what All County® has to offer.</p>
                      <!-- <a href="#" class="btn btn-sm btn-primary">Go somewhere</a> -->
                    </div>
                  </div>
                </div>
              </div>
            </section>
          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>