<?php
  // Add tenant turner API info
  // don't call the Tenant Turner API unless we have an ID to give it.
  // if(isset($locationData['TenantTurnerID'])) {
    if(isset($_GET['id'])) {
      $sanitize = new Sanitize();
      $listingID = $sanitize->numbersOnly($_GET['id']);
      // $tenantTurnerAccountID = $locationData['TenantTurnerID'];
      // $tenantTurnerAPI = new TenantTurner($tenantTurnerAccountID);
      // $recommendedListings = $tenantTurnerAPI->getListings(0);
      // $recommendedListings = array_slice($recommendedListings, 0, 4);
      // $listing = $tenantTurnerAPI->getListing(array($listingID));

      // Available Rentals V2
      $rentals = new TenantTurner();
      $listing = $rentals->getListings($listingID, '1' . $locationData['TenantTurnerPhone']);
      
      if(!$listing) {
        echo "<script>window.location = '../';</script>";
      }

      // find a way to determine the property management company from the title - maybe use the company name - this is a work in progress
      // $trimmedLocationName = str_replace(array(' ', '-', ','), '', $str);
      // echo $trimmedCompanyName;
    } else {
      $listings = 0;
    }
  // } else {
  //   $listings = 0;
  // }


?>
<!-- Page loading spinner-->
<?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Guidelines Modal -->
      <?php include_once($nestedLocation . 'resources/layouts/franchise/rentals/guidelines.modal.layout.php'); ?>

      <!-- Page content-->
      <!-- Page container-->
      <div class="container my-5 pb-lg-5">
        <div class="row g-0 mt-n3 pt-5">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-5">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>available-rentals/">Rentals</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $listing['address']; ?></li>
              </ol>
            </nav>

            <!-- Page title + Features-->
            <div class="order-lg-2 order-1">
              <h1 class="h2 mb-2"><?php echo $listing['propertyType']; ?></h1>
              <p class="mb-2 pb-1 fs-lg"><?php echo $listing['address'] . ', ' . $listing['city'] . ', ' . $listing['state'] . ' ' . $listing['zip'] ;?></p>
              <ul class="d-flex mb-4 pb-lg-2 list-unstyled">
                <li class="me-3 pe-3 border-end"><b class="me-1"><?php echo $listing['beds']; ?></b><i class="fi-bed mt-n1 lead align-middle text-muted"></i></li>
                <li class="me-3 pe-3 border-end"><b class="me-1"><?php echo $listing['baths']; ?></b><i class="fi-bath mt-n1 lead align-middle text-muted"></i></li>
              </ul>
            </div>

            <div class="row gy-5 pt-lg-2">
              <div class="col-lg-12">
                <div class="d-flex flex-column">
                  <!-- Carousel with slides count-->
                  <div class="order-lg-1 order-2">
                    <div class="gallery" data-thumbnails="true">
                      <?php if(!empty($listing['photos'])) { ?>
                      <div class="row g-2 g-md-3 mb-3">
                        <div class="<?php if(count($listing['photos']) > 1) { echo 'col-lg-8'; } else { echo 'col-lg-12'; } ?>">
                            <a class="gallery-item rounded rounded-md-3 cover-image" style="height: 595px; background-image: url('<?php echo $listing['photos'][0]; ?>');" href="<?php echo $listing['photos'][0]; ?>" data-sub-html="&lt;h6 class=&quot;fs-sm text-light&quot;&gt;Gallery image&lt;/h6&gt;"><img class="d-none" src="<?php echo $listing['photos'][0]; array_shift($listing['photos']); ?>" alt="Gallery thumbnail"></a>
                        </div>
                        <div class="col-lg-4">
                          <?php if(!empty($listing['photos'])) { ?>
                          <?php 
                            foreach ($listing['photos'] as $key => $photo) {
                              if ($key == 0) { ?>
                                  <a class="gallery-item rounded rounded-md-3 mb-3 cover-image" style="height: 290px; background-image: url('<?php echo $photo; ?>');" href="<?php echo $photo; ?>" data-sub-html="&lt;h6 class=&quot;fs-sm text-light&quot;&gt;Gallery image&lt;/h6&gt;"><img class="d-none" src="<?php echo $photo; ?>" alt="Gallery thumbnail"></a>
                              <?php } elseif ($key == 1) { ?>
                                <a class="gallery-item <?php if((count($listing['photos']) - 2) > 0) { echo 'more-item'; }; ?> rounded rounded-md-3 cover-image" style="height: 290px; background-image: url('<?php echo $photo; ?>');" href="<?php echo $photo; ?>" data-sub-html="&lt;h6 class=&quot;fs-sm text-light&quot;&gt;Gallery image&lt;/h6&gt;"><img class="d-none" src="<?php echo $photo; ?>" alt="Gallery thumbnail"><?php if((count($listing['photos']) - 2) > 0) { ?><span class="gallery-item-caption fs-base">+<?php echo (count($listing['photos']) - 1); ?> <span class='d-none d-md-inline'>photos</span></span><?php } ?></a></div>
                              <?php } else { ?> <div class="col-1"><a class="gallery-item d-none rounded rounded-md-3 cover-image" style="height: 290px; background-image: url('<?php echo $photo; ?>');" href="<?php echo $photo; ?>" data-sub-html="&lt;h6 class=&quot;fs-sm text-light&quot;&gt;Gallery image&lt;/h6&gt;"><img class="d-none" src="<?php echo $photo; ?>" alt="Gallery thumbnail"></a></div> <?php } 
                            }
                          ?>
                          <?php } } else { echo '<h4>No photos available.</h4>'; } ?>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-lg-8">
                <!-- Overview-->
                <h2 class="h5">Description:</h2>
                <p class="mb-4 pb-2">
                  <?php echo nl2br(preg_replace('/((http|ftp|https):\/\/[\w-]+(\.[\w-]+)+([\w.,@?^=%&amp;:\/~+#-]*[\w@?^=%&amp;\/~+#-])?)/', '<a target="_blank" href="\1">\1</a>', $listing['description'])); ?>
                </p>
              </div>
              <!-- Sidebar with details-->
              <aside class="col-lg-4">
                  <div class="row">
                    <div class="col-6">
                      <h3 class="h5 mb-2">Rent:</h3>
                      <h2 class="h2 mb-4 pb-2 text-primary">$<?php echo $listing['rentAmount'] ;?><span class="d-inline-block ms-1 fs-base fw-normal text-body"></span></h2>
                    </div>
                    <div class="col-6 justify-content-end text-end">
                      <img class="swap-from me-3" src="<?php echo $nestedLocation; ?>resources/img/acprop/fair_housing.png" alt="Logo" width="70px">
                    </div>
                  </div>
                  <div class="card border-0 bg-secondary mb-4">
                    <div class="card-body">
                      <h5 class="mb-0 pb-3" >Fees:</h5>
                      <ul class="list-unstyled mt-n2 mb-0">
                        <li class="mt-2 mb-0"><b>Security deposit: </b><?php if(is_numeric($listing['depositAmount'])) { echo '$'; } echo $listing['depositAmount']; ?></li>
                        <li class="mt-2 mb-0"><b>Application fee: </b>$<?php echo $listing['applicationFee']; ?></li>
                        <?php if(!str_contains($listing['leaseProcessingFee'], 'TBD')) { ?><li class="mt-2 mb-0"><b>Lease admin fee: </b>$<?php echo $listing['leaseProcessingFee']; ?></li><?php } ?>
                      </ul>
                    </div>
                  </div>
                  <!-- Property details-->
                  <div class="card border-0 bg-secondary mb-4">
                    <div class="card-body">
                      <h5 class="mb-0 pb-3">Property Details</h5>
                      <ul class="list-unstyled mt-n2 mb-0">
                        <li class="mt-2 mb-0"><b>Type: </b><?php echo $listing['propertyType']; ?></li>
                        <?php if(!empty($listing['squareFootage'])) { ?><li class="mt-2 mb-0"><b>Size: </b><?php echo $listing['squareFootage']; ?> sq. ft.</li><?php } ?>    
                        <li class="mt-2 mb-0"><b>Availability: </b><?php if (strtotime($listing['dateAvailable']) < time()) { echo 'Now'; } else { echo $listing['dateAvailable']; } ?></li>
                        <li class="mt-2 mb-0"><b>Bedrooms: </b><?php echo $listing['beds']; ?></li>
                        <li class="mt-2 mb-0"><b>Bathrooms: </b><?php echo $listing['baths']; ?></li>
                        <?php if(!is_null($listing['dogs']) || !is_null($listing['cats'])) { ?><li class="mt-2 mb-0"><b>Pets allowed: </b><?php if($listing['dogs'] && $listing['cats']) { echo 'Yes'; } else { if($listing['dogs']) { echo 'Dogs Only'; } elseif($listing['cats']) { echo 'Cats Only'; } else { echo 'No'; } } ?></li><?php } ?>
                        <?php if(!is_null($listing['isFurnished'])) { ?><li class="mt-2 mb-0"><b>Furnished: </b><?php if($listing['isFurnished']) { echo 'Yes'; } else { echo 'No'; } ?></li><?php } ?>
                        <?php if(!is_null($listing['housingAssistance'])) { ?><li class="mt-2 mb-0"><b>Housing Assistance: </b><?php if($listing['housingAssistance']) { echo 'Yes'; } else { echo 'No'; } ?></li><?php } ?>
                      </ul>
                    </div>
                  </div>
                  <?php if(!empty($listing['virtualTour'])) { ?><a class="btn btn-lg btn-primary w-100 mb-3" target="_blank" href="<?php echo $listing['virtualTour']; ?>">Take a virtual tour</a><?php } ?>
                  <?php if(!empty($listing['btnUrl'])) { ?><a class="btn btn-lg btn-primary w-100 mb-3" target="_blank" href="<?php echo $listing['btnUrl']; ?>">Schedule a showing</a><?php } ?>
                  <?php if(!empty($listing['applyUrl'])) { ?><a class="btn btn-lg btn-success w-100 mb-3" target="_blank" href="<?php echo $listing['applyUrl']; ?>">Apply now</a><?php } ?>
                  <!-- Rental agent-->
                  <!-- <h2 class="h5 mt-4">Listed by:</h2>
                  <div class="card card-horizontal">
                    <div class="card-img-top" style="background-image: url(<?php echo $latestOfficeImage['url']; ?>);"></div>
                    <div class="card-body d-flex flex-grow-1 justify-content-center align-items-center">
                     <div class="pe-3">
                        <h6 class="mb-0"><?php echo $listing['pmName']; ?></h6>
                        <div class="text-muted fw-normal fs-sm"><?php echo str_replace(" Property Management", "", $locationData['Franchise Name']); ?></div>
                      </div>
                    </div>
                  </div> -->
                </div>
              </aside>
            </div>

            <div class="d-flex align-items-center justify-content-between mb-3 mt-5">
              <h2 class="h3 mb-0">More listings</h2><a class="btn btn-link fw-normal p-0" href="../">View all<i class="fi-arrow-long-right ms-2"></i></a>
            </div>
            <div class="tns-carousel-wrapper tns-controls-outside-xxl tns-nav-outside tns-nav-outside-flush mx-n2">
              <div class="tns-carousel-inner row gx-4 mx-0 pt-3 pb-4" data-carousel-options="{&quot;items&quot;: 4, &quot;responsive&quot;: {&quot;0&quot;:{&quot;items&quot;:1},&quot;500&quot;:{&quot;items&quot;:2},&quot;768&quot;:{&quot;items&quot;:3},&quot;992&quot;:{&quot;items&quot;:4}}}">

                <?php if(!is_array($recommendedListings) && !isset($locationData['ShowMojo ID'])) { echo '<p>No listings available, please check back later.</p>'; } else { foreach($recommendedListings as $listing) { ?>
                <!-- Item-->
                <div class="col">
                  <div class="card shadow-sm card-hover border-0 h-100">
                    <a href="../listing/?id=<?php echo $listing['id']; ?>">
                      <div class="card-img-top card-img-hover recommended-rental-item-image" style="background-image: url('<?php echo $listing['photos'][0]; ?>');">
                      </div>
                    </a>
                    <div class="card-body position-relative pb-3">
                      <h4 class="mb-1 fs-xs fw-normal text-uppercase text-primary">For rent</h4>
                      <h3 class="h6 mb-2 fs-base"><a class="nav-link stretched-link" href="../listing/?id=<?php echo $listing['id']; ?>"><?php echo $listing['propertyType']; ?></a></h3>
                      <p class="mb-2 fs-sm text-muted"><?php echo $listing['address']; ?></p>
                      <?php if(!empty($listing['city']) || !empty($listing['state']) || !empty($listing['zip'])) { ?>
                      <p class="mb-2 fs-sm text-muted"><?php echo $listing['city'] . ', ' . $listing['state'] . ' ' . substr($listing['zip'], 0, 5); ?></p>
                      <?php } ?>
                      <div class="fw-bold"><i class="fi-cash mt-n1 me-2 lead align-middle text-primary"></i>$<?php echo $listing['rentAmount']; ?></div>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-center mx-3 pt-3 text-nowrap">
                      <span class="d-inline-block mx-1 px-2 fs-sm"><b><i class="fi-bed me-1 mt-n1 fs-lg text-primary"></i><?php echo $listing['beds']; ?> Beds</b></span>
                      <span class="d-inline-block mx-1 px-2 fs-sm"><b><i class="fi-bath me-1 mt-n1 fs-lg text-primary"></i><?php echo $listing['baths']; ?> Baths</b></span>
                    </div>
                    <div class="card-footer">
                      <div class="row">
                        <div class="col-12">
                          <a href="../listing/?id=<?php echo $listing['id']; ?>" class="text-decoration-none"><button type="button" class="btn btn-translucent-info d-block w-100">View</button></a>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <?php } } ?>
              </div>
            </div>
            
          </div>
        </div>
      </div>
    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/leaflet/dist/leaflet.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/lightgallery.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/fullscreen/lg-fullscreen.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/zoom/lg-zoom.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/thumbnail/lg-thumbnail.min.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>