    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Maintenance Guidelines Modal -->
      <?php include_once($nestedLocation . 'resources/layouts/franchise/residents/maintenance-guidelines.modal.layout.php'); ?>

      <!-- Portal Modal -->
      <?php include_once($nestedLocation . 'resources/layouts/modals/portal.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5 pt-4 pb-lg-5">
        <div class="row g-0 mt-n3 pt-sm-5">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-4">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Residents</li>
              </ol>
            </nav>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Residents | Portal & Maintenance</h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Pay rent online or submit a maintenance request using our easy and secure portal.</p>
              </div>
            </div>
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>
            <!-- Option cards-->
            <section class="container mb-4 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <!-- Item-->
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0">Portal | Pay Rent</h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">The tenant portal allows current residents of <b><?php echo $locationData['Franchise Name']; ?></b> to pay rent or Association Dues, view balances and sign documents.</span>
                    </div>
                    <div class="card-footer">
                      <a class="" href="#portal-modal" data-bs-toggle="modal"><h3 class="mt-4 h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Sign in</h3></a>
                    </div>
                  </div>
                </div>
                <!-- Item-->
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0">Maintenance Guidelines</h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Prior to submitting any maintenance request, please read our maintenance guidelines to ensure your requests are handled effeciently.</span>
                    </div>
                    <div class="card-footer">
                      <a href="#maintenance-guidelines" data-bs-toggle="modal"><h5 class="mt-4 h5 btn btn-secondary btn-block w-100 text-primary icon-box-title mb-0">Maintenance guidelines</h5></a>
                    </div>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0">Maintenance Request</h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">The All County Tenant Portal offers residents a convenient way to submit maintenance requests for a swift resolution.</span>
                    </div>
                    <div class="card-footer">
                      <?php if($maintenanceLink) { ?>
                      <a target="_blank" href="<?php echo $maintenanceLink; ?>"><h5 class="mt-3 h5 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Submit request</h5></a>
                      <?php } else { ?>
                      <a href="#portal-modal" data-bs-toggle="modal"><h3 class="mt-4 h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Submit request</h3></a>
                      <?php } ?>
                    </div>
                  </div>
                </div>
                <?php if($locationData['State'] == 'CO') { ?>
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0">Solicitud de mantenimiento</h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">El Portal de Inquilinos de All County ofrece a los residentes una forma conveniente de enviar solicitudes de mantenimiento para una rápida resolución de problemas.</span>
                    </div>
                    <div class="card-footer">
                      <?php if($maintenanceLink) { ?>
                      <a target="_blank" href="<?php echo $maintenanceLink; ?>"><h5 class="mt-3 h5 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Enviar solicitud</h5></a>
                      <?php } else { ?>
                      <a href="#portal-modal" data-bs-toggle="modal"><h3 class="mt-4 h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Enviar solicitud</h3></a>
                      <?php } ?>
                    </div>
                  </div>
                </div>
                <?php } ?>
                <?php if($locationData['Name'] == 'WYCowboy') { ?>
                <!-- Item-->
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0">Renters Insurance</h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">When you have renters insurance, you have peace of mind.</span>
                    </div>
                    <div class="card-footer">
                      <a target="_blank" href="https://allcountycowboy.sureapp.com/renters-insurance"><h5 class="mt-4 h5 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">Insurance Website</h5></a>
                    </div>
                  </div>
                </div>
                <?php } ?>
              </div>
            </section>



            <?php if(!empty($residentResources)) { ?>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-2 pb-sm-3">
              <h3 class="h3 mb-sm-0">Resources & Forms</h3>
            </div>
            <!-- <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Resources and forms for residents.</p>
              </div>
            </div> -->
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <section class="container mb-4 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <?php foreach($residentResources as $residentResource) { ?>
                <!-- Item-->
                <div class="col-md-3">
                  <div class="icon-box card card-hover h-100">
                    <div class="card-header">
                      <h5 class="mt-2 mb-0"><?php echo $residentResource['resource_title'] ?></h5>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body"><?php echo $residentResource['resource_content'] ?></span>
                    </div>
                    <div class="card-footer">
                        <a target="_blank" href="<?php echo $residentResource['resource_button'] ?>"><h3 class="mt-4 h4 btn btn-primary btn-block w-100 text-white icon-box-title mb-0">View</h3></a>
                    </div>
                  </div>
                </div>
                <?php } ?>
              </div>
            </section>
            <?php } ?>



            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h3 class="h3 mb-sm-0">Videos</h3>
            </div>
            <!-- <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Video resources for residents.</p>
              </div>
            </div> -->
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <section class="container mb-4 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <!-- Resource - Video -->
                <div class="col-md-6">
                  <div class="card gallery">
                    <div style="padding:56.25% 0 0 0;position:relative;">
                      <iframe class="rounded" src="https://player.vimeo.com/video/460685138?h=c9ea73d6bc&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Downloading the FSS Mobile App"></iframe>
                    </div>
                    <script src="https://player.vimeo.com/api/player.js"></script>
                    <div class="card-body">
                      <h5 class="card-title">Lease Presentation</h5>
                      <p class="card-text fs-sm text-muted">This video will help explain your lease.</p>
                      <!-- <a href="#" class="btn btn-sm btn-primary">Go somewhere</a> -->
                    </div>
                  </div>
                </div>
              </div>
            </section>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>

    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>