
    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page container-->
      <div class="container my-5 pb-lg-5">
        <div class="row g-0 mt-n3 pt-5">
          <!-- Page content-->
          <div class="col-lg-12 pb-5 pt-5">
            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $officeNestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item">About</li>
                <li class="breadcrumb-item active" aria-current="page">Our Team</li>
              </ol>
            </nav>
            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Meet our team</h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted">Meet the professional property managers looking over your rental property.</p>
              </div>
            </div>
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>


            <!-- What we do best -->
            <section class="container mb-5 pb-2 mt-sm-3">

              <div class="row gy-4 mt-4">

                <?php if(!empty($teamMembers)) { foreach($teamMembers as $tm) { ?>


                <div class="col-xl-3 col-lg-4 col-md-6 d-flex align-items-stretch pe-lg-4">
                  <div class="card w-100 shadow-sm">
                    
                      <div class="card-header text-center text-primary pb-0">
                        <div class="d-block mx-auto mt-2 mb-4 rounded-circle profile-icon" style="background-image: url('<?php if($tm['image_id']) { echo 'https://allcountyresources.com/locations/' . $locationData['Name'] . '/team-member-images/' . $tm['image_id'] . '.jpg'; } else { echo 'https://allcountyresources.com/locations/Default/team-member-images/default-member.png'; } ?>');" alt="Icon"></div>
                      </div>

                    <div class="card-body text-center">
                      <h6 style="font-weight: heavy;"><?php echo $tm['first_name'] . ' ' . $tm['last_name']; ?></h6>
                      <p>
                        <?php echo $tm['title']; ?>
                      </p>
                    </div>

                  </div>
                </div>

                <?php } } else { echo 'No team members found.'; } ?>

              </div>
            </section>

            <!-- CTA/OPTS -->
            <div class="mt-sm-5">
              <?php include_once($nestedLocation . 'resources/layouts/franchise/components/cta-opts.layout.php'); ?>
            </div>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button-->
    <a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up"></i></a>

    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>
