<?php
// Inject CORE
$nestedLocation = '../';
include($nestedLocation . 'resources/includes/core/acpm/services/core.php');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">
 
      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->
      <div class="container mt-5">
        <div class="row g-0 mt-n3">
          <!-- Page content-->
          <div class="col-lg-12 pt-5">

            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Services</li>
              </ol>
            </nav>

            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Services</h1>
              <!-- <a class="d-inline-block mb-5 mb-md-0 fw-bold text-decoration-none py-1 text-center" href="<?php echo $nestedLocation; ?>locations/states/">View By State<br><span class="display-1 text-primary stateface stateface-replace stateface-us"></span></a> -->
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted"><?php echo $pageMetaDescription; ?></p>
              </div>
            </div>
            
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <!-- Everything you need -->
            <section class="container mt-5">
              <div class="d-flex align-items-center justify-content-center text-center">
                <h2 class="h2 mb-3 text-primary fw-bold"><i><b>All County Gives You Everything You Need<br>To Suceed In Real Estate Investment!</b></i></h2>
              </div>
              <p class="text-center">We have been operating more than 30 years and understand what it takes to make the most money from your rental.</p>
            </section>

            <!-- Our services -->
            <section class="container my-5" id="ourservices">
              <div class="row pt-5">
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0">
                      <i class="fi-rent mb-4 display-6 text-primary"></i>
                      <br>
                      Comprehensive advertising
                    </div>
                    <div class="card-body">
                      <p>Our goal is to reach all of the applicants looking for your property.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0">
                      <i class="fi-user-check mb-4 display-6 text-primary"></i>
                      <br>Tenant placement
                    </div>
                    <div class="card-body">
                      <p>Let us take the hassle out of finding and placing. We will make sure a quality tenant is living in your property.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-file mb-4 display-6 text-primary"></i><br>Lease preparation and negotiation</div>
                    <div class="card-body">
                      <p>Our qualified team creates and executes all leases with detail as well as care.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-security mb-4 display-6 text-primary"></i><br>Lease compliance</div>
                    <div class="card-body">
                      <p>Our team of attorneys keep our documents and procedures up to date for everyone's safety.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-cash mb-4 display-6 text-primary"></i><br>Rigorous collection practices</div>
                    <div class="card-body">
                      <p>Having convenient online payment options and partnerships with companies who process money orders directly to residents ledgers.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-truck mb-4 display-6 text-primary"></i><br>Maintenance coordination</div>
                    <div class="card-body">
                      <p>Better response time and cost to you have been built because of our vendor relationships</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-home mb-4 display-6 text-primary"></i><br>Regular inspections</div>
                    <div class="card-body">
                      <p>Make sure your most valuable assets has our team watching over.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-flame mb-4 display-6 text-primary"></i><br>24 hour emergency services</div>
                    <div class="card-body">
                      <p>Let us take the headache out of those 2am calls.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-briefcase mb-4 display-6 text-primary"></i><br>Easy reporting</div>
                    <div class="card-body">
                      <p>Our robust system makes it easy to visualize your investments via easy to read reports.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-cup mb-4 display-6 text-primary"></i><br>Budget forecasting</div>
                    <div class="card-body">
                      <p>Know exactly when and how much you receive back from your investment with our advanced portal.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-device-laptop mb-4 display-6 text-primary"></i><br>Owner and tenant online access</div>
                    <div class="card-body">
                      <p>Our online web portal allows both you and the tenant to make payments and track maintenance requests.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-award mb-4 display-6 text-primary"></i><br>Strong communication</div>
                    <div class="card-body">
                      <p>At All County we pride ourselves on our superior customer service and the foundation of that is our outstanding communication with our clients.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-search mb-4 display-6 text-primary"></i><br>Rent analysis and renewals</div>
                    <div class="card-body">
                      <p>Our cutting edge software ensures you receive top dollar for your rental property.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-plus-circle mb-4 display-6 text-primary"></i><br>Increased return on investment</div>
                    <div class="card-body">
                      <p>With years of industry experience you can rest assured that your property is bringing you a healthy return on your investment.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 d-flex align-items-stretch mb-5">
                  <div class="card w-100 text-center border-0">
                    <div class="card-header h5 border-0"><i class="fi-eye-on mb-4 display-6 text-primary"></i><br>Transparent pricing</div>
                    <div class="card-body">
                      <p>As owner your ability to track expenses through our online portal demonstrates our commitment to saving you money by not marking up maintenance costs.</p>
                    </div>
                    <!-- <div class="card-footer border-0">
                      <div class="btn btn-sm text-black btn-secondary">Learn more</div>
                    </div> -->
                  </div>
                </div>
              </div>
            </section>


            <!-- CTA-->
            <?php include_once($nestedLocation . 'resources/layouts/widgets/cta.layout.php'); ?>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>
  </body>
</html>