<?php
// Inject CORE
$nestedLocation = '../';
include($nestedLocation . 'resources/includes/core/acpm/terms/core.php');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page content-->
      <div class="container mt-5">
        <div class="row g-0 mt-n3">
          <!-- Page content-->
          <div class="col-lg-12 pt-5">

            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Terms & Conditions</li>
              </ol>
            </nav>

            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Terms & Conditions</h1>
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted"><?php echo $pageMetaDescription; ?></p>
              </div>
            </div>
            
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <div class="container pt-3">
              <ol>
                <li style="list-style-type:decimal;font-size:12pt;">
                    <p><span style="font-size:12pt;">You will receive text messages about your property with updates, changes or information on natural disasters.</span></p>
                </li>
              </ol>
              <p style="text-align: center;"><span style="font-size:12pt;">THE TYPES OF INFORMATION WE COLLECT</span></p>
              <p style="text-align: center;"><span style="font-size:12pt;">We collect nonpublic information from the following sources:</span></p>
              <ul>
                  <li style="list-style-type:disc;font-size:12pt;">
                      <p><span style="font-size:12pt;">Information that we receive from you on applications or other forms (such as your name and address).</span></p>
                  </li>
                  <li style="list-style-type:disc;font-size:12pt;">
                      <p><span style="font-size:12pt;">Information obtained during conversations with you, or observed during visits to your premises.</span></p>
                  </li>
                  <li style="list-style-type:disc;font-size:12pt;">
                      <p><span style="font-size:12pt;">Information gathered during the course of managing your property association or business.</span></p>
                  </li>
                  <li style="list-style-type:disc;font-size:12pt;">
                      <p><span style="font-size:12pt;">To collect customer information from the above-stated sources, All County&reg; use the following means of communication to gather information: written, in-person, texting, telephone, facsimile, electronically and online.</span></p>
                  </li>
              </ul>
              <ol start="2">
                  <li style="list-style-type:decimal;font-size:12pt;">
                      <p><strong><span style="font-size:12pt;">Opt In/Out:</span></strong><span style="font-size:12pt;">&nbsp;You can cancel the SMS service at any time. Just text &ldquo;STOP&rdquo; to the short code. After you send the SMS message &ldquo;STOP&rdquo; to us, we will send you an SMS message to confirm that you have been unsubscribed. After this, you will no longer receive SMS messages from us. If you want to join again, just sign up as you did the first time and we will start sending SMS messages to you again.</span></p>
                  </li>
                  <li style="list-style-type:decimal;font-size:12pt;">
                      <p><span style="font-size:12pt;">If you are experiencing issues with the messaging program you can reply with the keyword HELP for more assistance, or you can get help directly with your local office location.</span></p>
                  </li>
                  <li style="list-style-type:decimal;font-size:12pt;">
                      <p><span style="font-size:12pt;">Carriers are not liable for delayed or undelivered messages.</span></p>
                  </li>
                  <li style="list-style-type:decimal;font-size:12pt;">
                      <p><span style="font-size:12pt;">As always, message and data rates may apply for any messages sent to you from us and to us from you. You will receive texts when information needs to be relayed about your residence or property. If you have any questions about your text plan or data plan, it is best to contact your wireless provider.</span></p>
                  </li>
                  <li style="list-style-type:decimal;font-size:12pt;">
                      <p><span style="font-size:12pt;">We do not share your information with third party affiliates.</span></p>
                  </li>
                  <li style="list-style-type:decimal;font-size:12pt;">
                      <p><span style="font-size:12pt;">If you have any questions regarding privacy, please read our privacy policy:</span></p>
                  </li>
              </ol>
              <p><span style="font-size:12pt;">You can contact All County&reg; Property Management</span></p>
              <p><span style="font-size:11pt;">Phone: (727) 800-3700</span><span style="font-size:11pt;"><br></span><span style="font-size:11pt;">Fax: (855) 243-RENT</span><span style="font-size:11pt;"><br></span><span style="font-size:11pt;">Email: contact@allcountyprop.com</span><span style="font-size:11pt;"><br></span><span style="font-size:11pt;">Address: 1700 66th St N Suite #402, St. Petersburg, FL 33710</span><span style="font-size:11pt;"><br></span><span style="font-size:11pt;">Entity: All County Property Management Franchise Corp</span></p>
              <p><br></p>
              <p><br></p>
            </div>

            <!-- CTA-->
            <?php include_once($nestedLocation . 'resources/layouts/widgets/cta.layout.php'); ?>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/lightgallery.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/fullscreen/lg-fullscreen.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/zoom/lg-zoom.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/video/lg-video.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/lightgallery/plugins/thumbnail/lg-thumbnail.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

    <div class="lg-container" id="lg-container-2" tabindex="-1" aria-modal="true" role="dialog">
      <div id="lg-backdrop-2" class="lg-backdrop" style="transition-duration: 300ms;"></div>
      <div id="lg-outer-2" class="lg-outer lg-use-css3 lg-css3 lg-single-item lg-slide lg-use-transition-for-zoom lg-hide-items lg-grab" data-lg-slide-type="video">
        <div id="lg-content-2" class="lg-content" style="top: 47px; bottom: 56px;">
          <div id="lg-inner-2" class="lg-inner" style="transition-timing-function: ease; transition-duration: 400ms;"></div>
          <button type="button" id="lg-prev-2" aria-label="Previous slide" class="lg-prev lg-icon">  </button>
          <button type="button" id="lg-next-2" aria-label="Next slide" class="lg-next lg-icon">  </button>
        </div>
        <div id="lg-toolbar-2" class="lg-toolbar lg-group"> 
          <button type="button" aria-label="Close gallery" id="lg-close-2" class="lg-close lg-icon"></button>
          <div class="lg-counter" role="status" aria-live="polite">
          <span id="lg-counter-current-2" class="lg-counter-current">1</span> /
          <span id="lg-counter-all-2" class="lg-counter-all">1 </span>
        </div>
        <button id="lg-actual-size-2" type="button" aria-label="View actual size" class="lg-zoom-in lg-icon"></button>
        <button type="button" aria-label="Toggle Fullscreen" class="lg-fullscreen lg-icon"></button>
      </div>
      <div id="lg-components-2" class="lg-components">
        <div class="lg-sub-html" role="status" aria-live="polite">
          <h6 class="fs-sm text-light">Gallery video caption</h6>
        </div>
      </div>
    </div>


  </body>
</html>