<?php
// Inject CORE
$nestedLocation = '../';
include($nestedLocation . 'resources/includes/core/acpm/why/core.php');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <!-- Head layout -->
    <?php include_once($nestedLocation . 'resources/layouts/head.layout.php'); ?>
  </head>
  <!-- Body-->
  <body>

    <!-- Page loading spinner-->
    <?php include_once($nestedLocation . 'resources/layouts/page-loader.layout.php'); ?>

    <main class="page-wrapper">

      <!-- Navbar-->
      <?php include_once($nestedLocation . 'resources/layouts/navigation-bar.layout.php'); ?>

      <!-- Page container-->
      <div class="container mt-5">
        <div class="row g-0 mt-n3">
          <!-- Page content-->
          <div class="col-lg-12 pt-5">

            <!-- Breadcrumb-->
            <nav class="mb-3 pt-md-2" aria-label="Breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo $nestedLocation; ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Why Partner With Us</li>
              </ol>
            </nav>

            <!-- Title and description -->
            <div class="d-sm-flex align-items-center justify-content-between pb-3 pb-sm-4">
              <h1 class="h1 mb-sm-0">Why Partner With Us</h1>
              <!-- <a class="d-inline-block mb-5 mb-md-0 fw-bold text-decoration-none py-1 text-center" href="<?php echo $nestedLocation; ?>locations/states/">View By State<br><span class="display-1 text-primary stateface stateface-replace stateface-us"></span></a> -->
            </div>
            <div class="row mb-4">
              <div class="col-lg-5 col-md-6">
                <p class="mb-0 fs-lg text-muted"><?php echo $pageMetaDescription; ?></p>
              </div>
            </div>
            
            <!-- Divider and sorting -->
            <div class="d-flex flex-sm-row flex-column align-items-sm-center align-items-stretch my-2">
              <hr class="d-none d-sm-block w-100">
            </div>

            <!-- Option cards-->
            <section class="container mb-5 pb-2 pb-md-4 pb-lg-5 mt-sm-5">
              <div class="row g-4">
                <!-- Item-->
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                    <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.quality-tenants.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Quality Tenants</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Your tenants are run through a rigorous screening process to ensure your properties have the best quality tenants with long term leases to reduce vacancies and increase your per unit profits.</span>
                      <br>
                      <b>We screen tenants based on:</b>
                      <ul class="mt-2">
                        <li>Credit Check</li>
                        <li>Background Check</li>
                        <li>Criminal Check</li>
                        <li>Sex Offender</li>
                        <li>Renting History</li>
                        <li>Terrorist Watch List</li>
                      </ul>
                    </div>
                  </div>
                </div>
                <!-- Item-->
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                  <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.fewer-vacancies.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Fewer & Shorter Vacancies</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">We have more tenants than properties so our managed properties are always filled. Most of our properties all filled within less than 30 days. The three things that affect you vacancy rate are location, price and condition. Your location is set. We help you work on price and condition to ensure your assets, rent quickly we have an abundance of tenants so we need more properties to manage. You won’t have to worry about having a vacant property</span>
                    </div>
                  </div>
                </div>
                <!-- Item-->
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                    <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.effective-collections.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Effective Collections</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">We make getting you paid simple and easy. Tenants use our online Tenant portal to automate paying rent by credit or cash card. In a pinch, your tenants can receive help from national charities to help cover their rent. Collection differs state by state. Every office has a different grace period, and all of our offices are trained and well versed in their local collection regulations.</span>
                      <br>
                      <b>We make rent-payment easy:</b>
                      <ul class="mt-2">
                        <li>Online Tenant Portal</li>
                        <li>Cash pay option</li>
                        <li>Credit Cards accepted</li>
                        <li>Emergency Rental Support Services available to help struggling tenants pay rent.</li>
                      </ul>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                    <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.fewer-headaches.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Fewer Headaches</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">We strip away all the hassle and frustration with managing properties. No more late night calls for maintenance. No more running down tenants for rent. No more weekends or nights spent managing your asset. Simply find and purchase a property and we’ll take care of the rest.</span>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                    <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.speedy-legal.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Speedy Legal</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">We have an excellent system for placing tenant, but every once in a while a bad tenant fakes their way through the interview process. When that happens, we work with our nationwide network of professional attorneys to quickly evict tenants within the laws of that state.</span>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                    <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.maintenance.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Maintenance</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Be assured that there will not be a charge on your bills for maintenance Maintenance is handled by our list of qualified, pre-vetted vendors who are licensed and insured. Because of our long-term relationships with them and the scale of work we provide we are able to provide you the best rates, and never see a charge for it, period.</span>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                    <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.local-experience.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Local Experience</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Our franchisees are locally owned and operated by members of your community to ensure you work with those who get you and your community. To search for a local Franchisee, enter your zip code here.</span>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                    <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.comprehensive-reporting.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Comprehensive Accounting/Tax Reporting</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">Our state of the art web software makes it easy and painless to get reports on your properties for accounting and tax purposes. These are easily accessed in your own web portal.</span>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="card card-hover h-100">
                    <img class="card-img-top" src="<?php echo $nestedLocation; ?>resources/img/property-management/why-ac.improved-cash-flow.jpg">
                    <div class="card-header">
                      <h3 class="mt-2 mb-0">Improved Cash Flow</h3>
                    </div>
                    <div class="card-body">
                      <span class="d-block mb-1 text-body">We boost your cash flow in 3 ways. One, we work to lower your expenses to ensure your tenants are held responsible for repairs and basic maintenance. Two, we ensure your rental is offered at the highest market rate. Three, we pair you with a local franchisee to ensure your property is managed by a professional with local market experience (this minimizes your risk of compliance issues).</span>
                    </div>
                  </div>
                </div>
              </div>
            </section>


            <!-- CTA-->
            <?php include_once($nestedLocation . 'resources/layouts/widgets/cta.layout.php'); ?>

          </div>
        </div>
      </div>

    </main>

    <!-- Footer-->
    <?php include_once($nestedLocation . 'resources/layouts/footer.layout.php'); ?>

    <!-- Back to top button--><a class="btn-scroll-top" href="#top" data-scroll><span class="btn-scroll-top-tooltip text-muted fs-sm me-2">Top</span><i class="btn-scroll-top-icon fi-chevron-up">   </i></a>
    <!-- Vendor scrits: js libraries and plugins-->
    <script src="<?php echo $nestedLocation; ?>resources/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/simplebar/dist/simplebar.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/smooth-scroll/dist/smooth-scroll.polyfills.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/nouislider/dist/nouislider.min.js"></script>
    <script src="<?php echo $nestedLocation; ?>resources/vendor/tiny-slider/dist/min/tiny-slider.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="assets/js/libs/handlebars.min.js"></script>
    <script src="assets/js/libs/markerclusterer.min.js"></script>
    <script src="https://maps.google.com/maps/api/js?key=AIzaSyB_Gi3u4O-b1fcwa0jnhW0RL2HV9MAC2Sg&libraries=places"></script>
    <script src="assets/js/plugins/storeLocator/jquery.storelocator.js"></script>
    <!-- Main theme script-->
    <script src="<?php echo $nestedLocation; ?>resources/js/theme.js"></script>

  </body>
</html>